#include "Mix/Tool/Win32/Core/Dynamics/CapsuleShape.h"

#include <vector>

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

void CapsuleShape::GetParam(	const D3DXVECTOR3& halfExtents,
								Mix::Tool::Win32::Dynamics::AXIS& axis,
								float& length,
								float& radius )
{
	std::vector<CapsuleShape::AXIS_INFO> aiList;

	aiList.push_back( CapsuleShape::AXIS_INFO( Mix::Tool::Win32::Dynamics::aX, halfExtents.x ) );
	aiList.push_back( CapsuleShape::AXIS_INFO( Mix::Tool::Win32::Dynamics::aY, halfExtents.y ) );
	aiList.push_back( CapsuleShape::AXIS_INFO( Mix::Tool::Win32::Dynamics::aZ, halfExtents.z ) );
	std::sort( aiList.begin(), aiList.end(), CapsuleShape::AXIS_INFO() );

	axis = aiList[0].type;
	length = aiList[0].length * 2.0f;
	radius = aiList[1].length;
}

}}}}
