#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/Shape.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class CapsuleShape : public Mix::Tool::Win32::Dynamics::Shape
	{
	private:
		struct AXIS_INFO
		{
			Mix::Tool::Win32::Dynamics::AXIS type;
			float length;

			AXIS_INFO( void ) {}
			AXIS_INFO( Mix::Tool::Win32::Dynamics::AXIS _type, float _length )
			{
				type = _type;
				length = _length;
			}

			bool operator()( const CapsuleShape::AXIS_INFO& l, const CapsuleShape::AXIS_INFO& r )
			{
				return ( l.length > r.length );
			}
		};

	public:
		virtual ~CapsuleShape( void ) {}

	public:
		virtual Mix::Tool::Win32::Dynamics::AXIS GetAxis( void ) const = 0;
		virtual float GetRadius( void ) const = 0;
		virtual float GetLength( void ) const = 0;

		static void GetParam(	const D3DXVECTOR3& halfExtents,
								Mix::Tool::Win32::Dynamics::AXIS& axis,
								float& length,
								float& radius );

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__CAPSULE_SHAPE, Mix::Tool::Win32::Dynamics::Shape )
	};

}}}}
