#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class LineHelper;
}}}}

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class CollisionObject : public Mix::Tool::Win32::Object
	{
	public:
		virtual ~CollisionObject( void ) {}

	public:
		virtual void SetGroup( short data ) = 0;
		virtual short GetGroup( void ) const = 0;

		virtual void SetGroupMask( short data ) = 0;
		virtual short GetGroupMask( void ) const = 0;

		virtual D3DXQUATERNION GetWorldRotation( void ) const = 0;
		virtual void SetWorldRotation( const D3DXQUATERNION& rot ) = 0;

		virtual D3DXVECTOR3 GetWorldPosition( void ) const = 0;
		virtual void SetWorldPosition( const D3DXVECTOR3& pos ) = 0;

		virtual D3DXMATRIX GetWorldMatrix( void ) const = 0;
		virtual void SetWorldMatrix( const D3DXMATRIX& mat ) = 0;

		virtual void SetWorldTransform( const D3DXQUATERNION& rot, const D3DXVECTOR3& pos ) = 0;

		virtual bool IsInWorld( void ) const = 0;

		virtual void Draw( Mix::Tool::Win32::Graphics::LineHelper* pLineHelper, const D3DXVECTOR4& color ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__COLLISION_OBJECT, Mix::Tool::Win32::Object )
	};

}}}}
