#pragma once

#include <vector>

#include "Mix/Tool/Win32/Core/File/OutputStream.h"
#include "Mix/Tool/Win32/Core/Object.h"
#include "Mix/Tool/Win32/Core/Graphics/Model.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class OctreeModel;
}}}}

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{
	class StaticMesh;
}}}}

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Design{

	class Terrain : public Mix::Tool::Win32::Object
	{
	public:
		//! @struct OCTREE_MODEL_CONFIG
		//! @brief ؃fݒ\
		struct OCTREE_MODEL_CONFIG
		{
			Mix::Tool::Win32::Graphics::Model::IMPORT_OPTION_TYPE opt; //!< IvV

			float scaling;					//!< XP[
			D3DXVECTOR3 rotation;			//!< ]
			D3DXVECTOR3 translation;		//!< ړ

			D3DXVECTOR3 cellSize;			//!< ZTCY
			float cellError;				//!< ZTCY̌덷̋e͈
		};

		//! @struct PART
		//! @brief p[g\
		struct PART
		{
			std::wstring name;
			D3DXVECTOR4 color;
			std::wstring imageFilePath;

			PART( void )
			{
				name = L"";
				color = D3DXVECTOR4( 1.0f, 1.0f, 1.0f, 1.0f );
				imageFilePath = L"";
			}
		};

	private:
		Terrain::OCTREE_MODEL_CONFIG m_OctreeModelConfig;
		Mix::Tool::Win32::Graphics::OctreeModel* m_pOctreeModel;
		Mix::Tool::Win32::Dynamics::StaticMesh* m_pStaticMesh;
		std::vector<Terrain::PART> m_PartList;
		std::vector<Mix::Tool::Win32::Dynamics::MATERIAL> m_MaterialList;
		bool m_bImported;

	public:
		Terrain( void );
		virtual ~Terrain( void );

		//}bvfݒ肳܂
		void SetOctreeModelConfig( const Terrain::OCTREE_MODEL_CONFIG& cfg );

		bool Import( const wchar_t* pFilePath, unsigned int serializeCapacity );
		bool ImportFinalize( void );
		bool IsImported( void ) const;
		void Destroy( void );

		unsigned int GetShapeSize( void ) const;
		unsigned int GetPolygonNum( void ) const;
		unsigned int GetPartNum( void ) const;

		const Terrain::PART* Part_Get( int index ) const;
		bool Part_SetMaterial( int partIndex, const Mix::Tool::Win32::Dynamics::MATERIAL& material );

		bool Write( Mix::Tool::Win32::File::OutputStream& output );

		Mix::Tool::Win32::Graphics::OctreeModel* GetOctreeModelPtr( void );

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__DESIGN_TERRAIN, Mix::Tool::Win32::Object )
	};

}}}}}
