#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class World;
	class StaticPlane;
	class StaticMesh;
	class BoxShape;
	class CapsuleShape;
	class SphereShape;
	class CompoundShape;
	class PointJoint;
	class HingeJoint;
	class BallJoint;
	class RigidBody;
	class KinematicCharacter;

	namespace Design
	{
		class Actor;
		class Terrain;
	};

	class Factory : public Mix::Tool::Win32::Object
	{
	public:
		static Mix::Tool::Win32::Dynamics::World* CreateWorld( void );

		static Mix::Tool::Win32::Dynamics::StaticPlane* CreateStaticPlane( void );
		static Mix::Tool::Win32::Dynamics::StaticMesh* CreateStaticMesh( void );

		static Mix::Tool::Win32::Dynamics::BoxShape* CreateBoxShape( const D3DXVECTOR3& halfExtents );
		static Mix::Tool::Win32::Dynamics::CapsuleShape* CreateCapsuleShape( Mix::Tool::Win32::Dynamics::AXIS axis, float radius, float length );
		static Mix::Tool::Win32::Dynamics::CapsuleShape* CreateCapsuleShape( const D3DXVECTOR3& halfExtents );
		static Mix::Tool::Win32::Dynamics::SphereShape* CreateSphereShape( float radius );
		static Mix::Tool::Win32::Dynamics::SphereShape* CreateSphereShape( const D3DXVECTOR3& halfExtents );
		static Mix::Tool::Win32::Dynamics::CompoundShape* CreateCompoundShape( void );

		static Mix::Tool::Win32::Dynamics::PointJoint* CreatePointJoint( void );
		static Mix::Tool::Win32::Dynamics::PointJoint* CreatePointJoint( bool collisionDisabled, float spring, float damper );

		static Mix::Tool::Win32::Dynamics::HingeJoint* CreateHingeJoint( void );
		static Mix::Tool::Win32::Dynamics::HingeJoint* CreateHingeJoint( const D3DXVECTOR3& axis, float lowerLimit, float upperLimit, bool collisionDisabled, float limitSpring, float limitDamper );

		static Mix::Tool::Win32::Dynamics::BallJoint* CreateBallJoint( void );
		static Mix::Tool::Win32::Dynamics::BallJoint* CreateBallJoint( const D3DXVECTOR3& swingAxis, const D3DXVECTOR3& twistAxis, float swingLimit1, float swingLimit2, float twistLimit, bool collisionDisabled, float spring, float damper, float limitSpring, float limitDamper );

		static Mix::Tool::Win32::Dynamics::RigidBody* CreateRigidBody( void );

		static Mix::Tool::Win32::Dynamics::KinematicCharacter* CreateKinematicCharacter( void );

		static Mix::Tool::Win32::Dynamics::Design::Actor* CreateActor( void );
		static Mix::Tool::Win32::Dynamics::Design::Terrain* CreateTerrain( void );

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__FACTORY, Mix::Tool::Win32::Object )
	};

}}}}
