#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/Joint.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class HingeJoint : public Mix::Tool::Win32::Dynamics::Joint
	{
	public:
		enum PARAM_AXIS
		{
			PA_NONE	= -1,
		};

		enum PARAM_TYPE
		{
			PT_STOP_ERP		= 2,	//~bg
			PT_NORMAL_CFM	= 3,	//[^[
			PT_STOP_CFM		= 4,	//~bg
		};

		//p[^̑gݍ킹
		//
		//PT_STOP_ERP   PA_NONE
		//PT_NORMAL_CFM PA_NONE
		//PT_STOP_CFM   PA_NONE

	public:
		virtual ~HingeJoint( void ) {}

		virtual const D3DXVECTOR3& GetNormalizeAxis( void ) const = 0;
		virtual const D3DXVECTOR3& GetAxis( void ) const = 0;
		virtual void SetAxis( const D3DXVECTOR3& axis ) = 0;

		virtual float GetLowerLimit( void ) const = 0;
		virtual void SetLowerLimit( float rad ) = 0;

		virtual float GetUpperLimit( void ) const = 0;
		virtual void SetUpperLimit( float rad ) = 0;

		virtual float GetLimitSpring( void ) const = 0;
		virtual void SetLimitSpring( float value ) = 0;

		virtual float GetLimitDamper( void ) const = 0;
		virtual void SetLimitDamper( float value ) = 0;

		virtual float GetNormalSpring( void ) const = 0;
		virtual void SetNormalSpring( float value ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__HINGE_JOINT, Mix::Tool::Win32::Dynamics::Joint )
	};

}}}}
