#include "Mix/Tool/Win32/Core/Dynamics/Impl/BoxShape.h"

#include "btBulletCollisionCommon.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

BoxShape::BoxShape( void ) :
m_pShape( NULL )
{
}

BoxShape::~BoxShape( void )
{
	MIX_DELETE( m_pShape );
}

bool BoxShape::Initialize( const D3DXVECTOR3& halfExtents )
{
	if( m_pShape != NULL )
	{
		return false;
	}

	m_pShape = new btBoxShape( btVector3( halfExtents.x, halfExtents.y, halfExtents.z ) );
	if( m_pShape == NULL )
	{
		return false;
	}

	m_HalfExtents = halfExtents;

	return true;
}

D3DXVECTOR3 BoxShape::GetHalfExtents( void ) const
{
	const btVector3& halfExtens = m_pShape->getHalfExtentsWithMargin();

	return D3DXVECTOR3( halfExtens.x(), halfExtens.y(), halfExtens.z() );
}

void* BoxShape::Bullet_GetCollisionShape( void )
{
	return m_pShape;
}

}}}}}
