#include "Mix/Tool/Win32/Core/Dynamics/Impl/CapsuleShape.h"
#include "btBulletCollisionCommon.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

CapsuleShape::CapsuleShape( void ) :
m_pShape( NULL )
{
}

CapsuleShape::~CapsuleShape( void )
{
	MIX_DELETE( m_pShape );
}

bool CapsuleShape::Initialize( Mix::Tool::Win32::Dynamics::AXIS axis, float radius, float length )
{
	if( m_pShape != NULL )
	{
		return false;
	}

	length = max( 0.0f, length - radius * 2.0f );

	switch( axis )
	{
	case Mix::Tool::Win32::Dynamics::aX:
		m_pShape = new ::btCapsuleShapeX( radius, length );
		break;
	case Mix::Tool::Win32::Dynamics::aY:
		m_pShape = new ::btCapsuleShape( radius, length );
		break;
	case Mix::Tool::Win32::Dynamics::aZ:
		m_pShape = new ::btCapsuleShapeZ( radius, length );
		break;
	}

	if( m_pShape == NULL )
	{
		return false;
	}

	return true;
}

Mix::Tool::Win32::Dynamics::AXIS CapsuleShape::GetAxis( void ) const
{
	Mix::Tool::Win32::Dynamics::AXIS axis;

	switch( m_pShape->getUpAxis() )
	{
	case 0:
		axis = Mix::Tool::Win32::Dynamics::aX;
		break;
	case 1:
		axis = Mix::Tool::Win32::Dynamics::aY;
		break;
	case 2:
		axis = Mix::Tool::Win32::Dynamics::aZ;
		break;
	}

	return axis;
}

float CapsuleShape::GetRadius( void ) const
{
	return m_pShape->getRadius();
}

float CapsuleShape::GetLength( void ) const
{
	return m_pShape->getHalfHeight() * 2.0f + m_pShape->getRadius() * 2.0f;
}

void* CapsuleShape::Bullet_GetCollisionShape( void )
{
	return m_pShape;
}

}}}}}
