#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Dynamics/CompoundShape.h"

class btCompoundShape;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

	class CompoundShape : public Mix::Tool::Win32::Dynamics::CompoundShape
	{
	private:
		typedef std::vector<Mix::Tool::Win32::Dynamics::Shape*> ChildList;

	private:
		btCompoundShape* m_pShape;
		CompoundShape::ChildList m_ChildList;

	public:
		CompoundShape( void );
		virtual ~CompoundShape( void );

		bool Initialize( void );

	public:
		virtual bool AddChild( Mix::Tool::Win32::Dynamics::Shape* pChild, const D3DXVECTOR3& centerPos, const D3DXQUATERNION& centerRot );
		virtual bool RemoveChild( Mix::Tool::Win32::Dynamics::Shape* pChild );

		virtual int GetChildCount( void ) const;
		virtual const Mix::Tool::Win32::Dynamics::Shape* GetChildPtr( int index ) const;

	public:
		virtual void* Bullet_GetCollisionShape( void );
	};

}}}}}
