#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/PointJoint.h"

class btPoint2PointConstraint;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

	class World;

	class PointJoint : public Mix::Tool::Win32::Dynamics::PointJoint
	{
	private:
		enum PRIVATE_VALUE
		{
			PT_MAX		= PointJoint::PT_CFM + 1,
		};

	private:
		btPoint2PointConstraint* m_pConstraint;
		Mix::Tool::Win32::Dynamics::Impl::World* m_pWorld;

		Mix::Tool::Win32::Dynamics::RigidBody* m_pRigidBodyA;
		Mix::Tool::Win32::Dynamics::RigidBody* m_pRigidBodyB;

		D3DXVECTOR3 m_PivotA;
		D3DXVECTOR3 m_PivotB;

		bool m_bCollisionDisabled;

		unsigned int m_ParamFlags;
		float m_ParamValues[PointJoint::PT_MAX];

	public:
		PointJoint( void );
		PointJoint( bool collisionDisabled, float spring, float damper );
		virtual ~PointJoint( void );

		void SetWorldPtr( Mix::Tool::Win32::Dynamics::Impl::World* pWorld );

	public:
		virtual float GetSpring( void ) const;
		virtual void SetSpring( float value );

		virtual float GetDamper( void ) const;
		virtual void SetDamper( float value );

	public:
		virtual void ResetInitalRigidBodyTransform( void );
		virtual void SetInitalRigidBodyTransform(	const D3DXQUATERNION& rotA,
													const D3DXVECTOR3& posA,
													const D3DXQUATERNION& rotB,
													const D3DXVECTOR3& posB );

		virtual bool SetFrame(	Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyA,
								const D3DXVECTOR3& pivotA );

		virtual bool SetFrame(	Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyA,
								Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyB,
								const D3DXVECTOR3& pivotA,
								const D3DXVECTOR3& pivotB );

		virtual const Mix::Tool::Win32::Dynamics::RigidBody* GetRigidBodyA( void ) const;
		virtual D3DXVECTOR3 GetPivotA( void );
		virtual void SetPivotA( const D3DXVECTOR3& pivot );

		virtual const Mix::Tool::Win32::Dynamics::RigidBody* GetRigidBodyB( void ) const;
		virtual D3DXVECTOR3 GetPivotB( void );
		virtual void SetPivotB( const D3DXVECTOR3& pivot );

		virtual bool GetCollisionDisabled( void ) const;
		virtual void SetCollisionDisabled( bool state );

		virtual bool IsParamSupported( int type, int axis = -1 ) const;
		virtual bool IsParamEnabled( int type, int axis ) const;
		virtual float GetParam( int type, int axis ) const;
		virtual void SetParam( int type, int axis, float value );
		virtual void ResetParam( int type, int axis );

		virtual void Draw(	Mix::Tool::Win32::Graphics::LineHelper* pLineHelper,
							const D3DXVECTOR4& axisColor,
							const D3DXVECTOR4& ballColor,
							const D3DXVECTOR4& limitColor,
							float scale );

		virtual void* Bullet_GetTypedConstraintPtr( void );

	private:
		void BeginRefresh( void );
		void EndRefresh( void );
		void Refresh( void );
		void UpdateParams( void );
	};

}}}}}
