#include "Mix/Tool/Win32/Core/Dynamics/Impl/SphereShape.h"
#include "btBulletCollisionCommon.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

SphereShape::SphereShape( void ) :
m_pShape( NULL )
{
}

SphereShape::~SphereShape( void )
{
	MIX_DELETE( m_pShape );
}

bool SphereShape::Initialize( float radius )
{
	if( m_pShape != NULL )
	{
		return false;
	}

	m_pShape = new btSphereShape( radius );
	if( m_pShape == NULL )
	{
		return false;
	}

	return true;
}

float SphereShape::GetRadius( void ) const
{
	return m_pShape->getRadius();
}

void* SphereShape::Bullet_GetCollisionShape( void )
{
	return m_pShape;
}

}}}}}
