#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Dynamics/StaticMesh.h"

class btTriangleMesh;
class btBvhTriangleMeshShape;
class btMotionState;
class btRigidBody;
class btDefaultSerializer;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

	class World;

	class StaticMesh : public Mix::Tool::Win32::Dynamics::StaticMesh
	{
	private:
		Mix::Tool::Win32::Dynamics::Impl::World* m_pWorld;

		btTriangleMesh* m_pMesh;
		btBvhTriangleMeshShape* m_pShape;
		btMotionState* m_pMotionState;
		btRigidBody* m_pRigidBody;
		btDefaultSerializer* m_pSerializer;

		std::vector<unsigned int> m_PolygonMaterials;
		std::vector<Mix::Tool::Win32::Dynamics::MATERIAL> m_Materials;

		short m_Group;
		short m_GroupMask;

	public:
		StaticMesh( void );
		virtual ~StaticMesh( void );

		void SetWorldPtr( Mix::Tool::Win32::Dynamics::Impl::World* pWorld );

		const Mix::Tool::Win32::Dynamics::MATERIAL* GetMaterialPtrByPolygonIndex( unsigned int polygonIndex ) const;

		btRigidBody* Bullet_GetRigidBodyPtr( void );

	private:
		static const Mix::Tool::Win32::Dynamics::MATERIAL DUMMY_MATERIAL;

		void BeginRefresh( void );
		void EndRefresh( void );

		void Release( void );

	public:
		virtual bool Load(	const void* vertices,
							unsigned int vertexStride,
							unsigned int vertexNum,
							const unsigned int* polygonIndices,
							const unsigned int* polygonMaterials,
							unsigned int polygonNum,
							const Mix::Tool::Win32::Dynamics::MATERIAL* materials,
							unsigned int materialNum,
							int capacity );

		virtual unsigned int GetShapeBufferSize( void ) const;
		virtual const void* GetShapeBufferPtr( void ) const;

		virtual unsigned int GetPolygonNum( void ) const;
		virtual unsigned int GetPolygonMaterial( unsigned int polygonIndex ) const;
		virtual bool SetPolygonMaterial( unsigned int polygonIndex, unsigned int materialIndex );
		virtual const unsigned int* GetPolygonMaterials( void ) const;

		virtual unsigned int GetMaterialNum( void ) const;
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL* GetMaterialPtr( unsigned int index ) const;
		virtual bool SetMaterial( unsigned int index, const Mix::Tool::Win32::Dynamics::MATERIAL& material );
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL* GetMaterials( void ) const;

	public:
		virtual short GetGroup( void ) const;
		virtual void SetGroup( short data );

		virtual short GetGroupMask( void ) const;
		virtual void SetGroupMask( short data );

		virtual D3DXQUATERNION GetWorldRotation( void ) const;
		virtual void SetWorldRotation( const D3DXQUATERNION& rot );

		virtual D3DXVECTOR3 GetWorldPosition( void ) const;
		virtual void SetWorldPosition( const D3DXVECTOR3& pos );

		virtual D3DXMATRIX GetWorldMatrix( void ) const;
		virtual void SetWorldMatrix( const D3DXMATRIX& mat );

		virtual void SetWorldTransform( const D3DXQUATERNION& rot, const D3DXVECTOR3& pos );

		virtual bool IsInWorld( void ) const;

		virtual void Draw( Mix::Tool::Win32::Graphics::LineHelper* pLineHelper, const D3DXVECTOR4& color );

		friend class Factory;
	};

}}}}}
