#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/StaticPlane.h"

class btStaticPlaneShape;
class btMotionState;
class btRigidBody;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Impl{

	class World;

	class StaticPlane : public Mix::Tool::Win32::Dynamics::StaticPlane
	{
	private:
		Mix::Tool::Win32::Dynamics::Impl::World* m_pWorld;

		btStaticPlaneShape* m_pShape;
		btMotionState* m_pMotionState;
		btRigidBody* m_pRigidBody;

		Mix::Tool::Win32::Dynamics::MATERIAL m_Material;

		short m_Group;
		short m_GroupMask;

	public:
		StaticPlane( void );
		virtual ~StaticPlane( void );

		bool Initialize( void );

		void SetWorldPtr( Mix::Tool::Win32::Dynamics::Impl::World* pWorld );

		btRigidBody* Bullet_GetRigidBodyPtr( void );

	public:
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL& GetMaterial( void ) const;
		virtual void SetMaterial( const Mix::Tool::Win32::Dynamics::MATERIAL& material );

	public:
		virtual short GetGroup( void ) const;
		virtual void SetGroup( short data );

		virtual short GetGroupMask( void ) const;
		virtual void SetGroupMask( short data );

		virtual D3DXQUATERNION GetWorldRotation( void ) const;
		virtual void SetWorldRotation( const D3DXQUATERNION& rot );

		virtual D3DXVECTOR3 GetWorldPosition( void ) const;
		virtual void SetWorldPosition( const D3DXVECTOR3& pos );

		virtual D3DXMATRIX GetWorldMatrix( void ) const;
		virtual void SetWorldMatrix( const D3DXMATRIX& mat );

		virtual void SetWorldTransform( const D3DXQUATERNION& rot, const D3DXVECTOR3& pos );

		virtual bool IsInWorld( void ) const;

		virtual void Draw( Mix::Tool::Win32::Graphics::LineHelper* pLineHelper, const D3DXVECTOR4& color );

	private:
		void BeginRefresh( void );
		void EndRefresh( void );

		friend class Factory;
	};

}}}}}
