#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class LineHelper;
}}}}

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class RigidBody;

	class Joint : public Mix::Tool::Win32::Object
	{
	public:
		virtual ~Joint( void ) {}

		virtual void ResetInitalRigidBodyTransform( void ) = 0;
		virtual void SetInitalRigidBodyTransform(	const D3DXQUATERNION& rotA,
													const D3DXVECTOR3& posA,
													const D3DXQUATERNION& rotB,
													const D3DXVECTOR3& posB ) = 0;

		virtual bool SetFrame(	Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyA,
								const D3DXVECTOR3& pivotA ) = 0;

		virtual bool SetFrame(	Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyA,
								Mix::Tool::Win32::Dynamics::RigidBody* pRigidBodyB,
								const D3DXVECTOR3& pivotA,
								const D3DXVECTOR3& pivotB ) = 0;

		virtual const Mix::Tool::Win32::Dynamics::RigidBody* GetRigidBodyA( void ) const = 0;
		virtual D3DXVECTOR3 GetPivotA( void ) = 0;
		virtual void SetPivotA( const D3DXVECTOR3& pivot ) = 0;

		virtual const Mix::Tool::Win32::Dynamics::RigidBody* GetRigidBodyB( void ) const = 0;
		virtual D3DXVECTOR3 GetPivotB( void ) = 0;
		virtual void SetPivotB( const D3DXVECTOR3& pivot ) = 0;

		virtual bool GetCollisionDisabled( void ) const = 0;
		virtual void SetCollisionDisabled( bool state ) = 0;

		virtual bool IsParamSupported( int type, int axis ) const = 0;
		virtual bool IsParamEnabled( int type, int axis ) const = 0;
		virtual float GetParam( int type, int axis ) const = 0;
		virtual void SetParam( int type, int axis, float value ) = 0;
		virtual void ResetParam( int type, int axis ) = 0;

		virtual void Draw(	Mix::Tool::Win32::Graphics::LineHelper* pLineHelper,
							const D3DXVECTOR4& axisColor,
							const D3DXVECTOR4& ballColor,
							const D3DXVECTOR4& limitColor,
							float scale = 1.0f ) = 0;

		virtual void* Bullet_GetTypedConstraintPtr( void ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__JOINT, Mix::Tool::Win32::Object )
	};

}}}}
