#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/CollisionObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class KinematicCharacter : public Mix::Tool::Win32::Dynamics::CollisionObject
	{
	public:
		virtual ~KinematicCharacter( void ) {}

	public:
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		virtual void SetMaterial( const Mix::Tool::Win32::Dynamics::MATERIAL& material ) = 0;

		virtual void SetHeight( float height ) = 0;
		virtual float GetHeight( void ) const = 0;

		virtual void SetRadius( float radius ) = 0;
		virtual float GetRadius( void ) const = 0;

		virtual void SetGravity( float gravity ) = 0;
		virtual float GetGravity( void ) const = 0;

		virtual void SetMaxFallSpeed( float speed ) = 0;
		virtual float GetMaxFallSpeed( void ) const = 0;

		virtual void SetInitJumpSpeed( float speed ) = 0;
		virtual float GetInitJumpSpeed( void ) const = 0;

		virtual void SetStepOffset( float stepOffset ) = 0;
		virtual float GetStepOffset( void ) const = 0;

		virtual void SetSlopeLimit( float slopeLimit ) = 0;
		virtual float GetSlopeLimit( void ) const = 0;

		virtual void SetLinearVelocity( const D3DXVECTOR3& vel ) = 0;
		virtual const D3DXVECTOR3& GetLinearVelocity( void ) const = 0;

		virtual bool IsGround( void ) const = 0;

		virtual void Jump( void ) = 0;

	public:
		static const float DefaultRadius( void )
		{
			return 0.4f;
		}

		static const float DefaultHeight( void )
		{
			return 2.0f;
		}

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__KINEMATIC_CHARACTER, Mix::Tool::Win32::Dynamics::CollisionObject )
	};

}}}}
