#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/CollisionObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class Shape;

	class RigidBody : public Mix::Tool::Win32::Dynamics::CollisionObject
	{
	public:
		enum STATUS
		{
			DEFAULT		= 0,
			STATIC		= 1,
			KINEMATIC	= 2,
			SENSOR		= 3,
		};

	public:
		virtual ~RigidBody( void ) {}

	public:
		virtual HANDLE AddShape( Mix::Tool::Win32::Dynamics::Shape* pShape, const D3DXQUATERNION& rot, const D3DXVECTOR3& pos ) = 0;
		virtual bool RemoveShape( const HANDLE handle ) = 0;

		virtual Mix::Tool::Win32::Dynamics::Shape* GetShape( const HANDLE handle ) const = 0;
		virtual bool SetShape( const HANDLE handle, Mix::Tool::Win32::Dynamics::Shape* pShape ) = 0;

		virtual bool SetShapeTransform( const HANDLE handle, const D3DXQUATERNION& rot, const D3DXVECTOR3& pos ) = 0;

		virtual bool GetShapeRotation( const HANDLE handle, D3DXQUATERNION& rot ) const = 0;
		virtual bool SetShapeRotation( const HANDLE handle, const D3DXQUATERNION& rot ) = 0;

		virtual bool GetShapePosition( const HANDLE handle, D3DXVECTOR3& pos ) const = 0;
		virtual bool SetShapePosition( const HANDLE handle, const D3DXVECTOR3& pos ) = 0;

		virtual void SetHighlightShape( const HANDLE handle ) = 0;
		virtual const HANDLE GetHighlightShapeHandle( void ) const = 0;

		virtual int GetShapeHandleCount( void ) const = 0;
		virtual const HANDLE GetShapeHandle( int index ) const = 0;

		virtual float GetMass( void ) const = 0;
		virtual float GetInvMass( void ) const = 0;
		virtual void SetMass( float mass ) = 0;

		virtual const Mix::Tool::Win32::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		virtual void SetMaterial( const Mix::Tool::Win32::Dynamics::MATERIAL& material ) = 0;

		virtual D3DXVECTOR3 GetLinearVelocity( void ) = 0;
		virtual void SetLinearVelocity( const D3DXVECTOR3& vel ) = 0;

		virtual D3DXVECTOR3 GetAngularVelocity( void ) = 0;
		virtual void SetAngularVelocity( const D3DXVECTOR3& vel ) = 0;

		virtual D3DXVECTOR3 GetLinearFactor( void ) = 0;
		virtual void SetLinearFactor( const D3DXVECTOR3& factor ) = 0;

		virtual D3DXVECTOR3 GetAngularFactor( void ) = 0;
		virtual void SetAngularFactor( const D3DXVECTOR3& factor ) = 0;

		virtual float GetLinearDamping( void ) const = 0;
		virtual void SetLinearDamping( float damping ) = 0;

		virtual float GetAngularDamping( void ) const = 0;
		virtual void SetAngularDamping( float damping ) = 0;

		virtual bool GetAlwaysActive( void ) const = 0;
		virtual void SetAlwaysActive( bool state ) = 0;

		virtual RigidBody::STATUS GetStatus( void ) const = 0;
		virtual void SetStatus( RigidBody::STATUS status ) = 0;

		virtual void Reset( void ) = 0;
		virtual void Reset( const D3DXQUATERNION& rot, const D3DXVECTOR3& pos ) = 0;

		virtual void Activate( void ) = 0;
		virtual void Deactivate( void ) = 0;

		virtual void ApplyImpulse( const D3DXVECTOR3& impulse ) = 0;
		virtual void ApplyImpulse( const D3DXVECTOR3& impulse, const D3DXVECTOR3& relPos ) = 0;

		virtual void Draw( Mix::Tool::Win32::Graphics::LineHelper* pLineHelper, const D3DXVECTOR4& color ) = 0;
		virtual void Draw( Mix::Tool::Win32::Graphics::LineHelper* pLineHelper, const D3DXVECTOR4& defColor, const D3DXVECTOR4& selColor ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__RIGID_BODY, Mix::Tool::Win32::Dynamics::CollisionObject )
	};

}}}}
