#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/CollisionObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class StaticMesh : public Mix::Tool::Win32::Dynamics::CollisionObject
	{
	public:
		virtual ~StaticMesh( void ) {}

	public:
		virtual bool Load(	const void* vertices,
							unsigned int vertexStride,
							unsigned int vertexNum,
							const unsigned int* polygonIndices,
							const unsigned int* polygonMaterials,
							unsigned int polygonNum,
							const Mix::Tool::Win32::Dynamics::MATERIAL* materials,
							unsigned int materialNum,
							int capacity = 5 ) = 0;

		virtual unsigned int GetShapeBufferSize( void ) const = 0;
		virtual const void* GetShapeBufferPtr( void ) const = 0;

		virtual unsigned int GetPolygonNum( void ) const = 0;
		virtual unsigned int GetPolygonMaterial( unsigned int polygonIndex ) const = 0;
		virtual bool SetPolygonMaterial( unsigned int polygonIndex, unsigned int materialIndex ) = 0;
		virtual const unsigned int* GetPolygonMaterials( void ) const = 0;

		virtual unsigned int GetMaterialNum( void ) const = 0;
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL* GetMaterialPtr( unsigned int index ) const = 0;
		virtual bool SetMaterial( unsigned int index, const Mix::Tool::Win32::Dynamics::MATERIAL& material ) = 0;
		virtual const Mix::Tool::Win32::Dynamics::MATERIAL* GetMaterials( void ) const = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__STATIC_MESH, Mix::Tool::Win32::Dynamics::CollisionObject )
	};

}}}}
