#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class LineHelper;
}}}}

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class CollisionObject;
	class Joint;

	class World : public Mix::Tool::Win32::Object
	{
	public:
		enum DRAW_FLAG
		{
			COLLISION	= 0x00000001,
			CONSTRAINT	= 0x00000002,
		};

	public:
		virtual ~World( void ) {}

	public:
		virtual void SetGravity( const D3DXVECTOR3& gravity ) = 0;
		virtual D3DXVECTOR3 GetGravity( void ) = 0;

		virtual bool AddCollisionObject( Mix::Tool::Win32::Dynamics::CollisionObject* pCollisionObject ) = 0;
		virtual bool RemoveCollisionObject( Mix::Tool::Win32::Dynamics::CollisionObject* pCollisionObject ) = 0;

		virtual bool AddJoint( Mix::Tool::Win32::Dynamics::Joint* pJoint ) = 0;
		virtual bool RemoveJoint( Mix::Tool::Win32::Dynamics::Joint* pJoint ) = 0;

		virtual void Update( float dt ) = 0;

		virtual void Draw(	Mix::Tool::Win32::Graphics::LineHelper* pLineHelper,
							const D3DXVECTOR4& collObjColor = D3DXVECTOR4( 1.0f, 1.0f, 1.0f, 1.0f ),
							const D3DXVECTOR4& jointAxisColor = D3DXVECTOR4( 0.3f, 1.0f, 0.3f, 1.0f ),
							const D3DXVECTOR4& jointPivotColor = D3DXVECTOR4( 1.0f, 0.3f, 0.0f, 1.0f ),
							const D3DXVECTOR4& jointLimitColor = D3DXVECTOR4( 0.3f, 0.3f, 1.0f, 1.0f ) ) = 0;

		virtual void Picker_Catch( const D3DXVECTOR3& eyePos, const D3DXVECTOR3& fromWorldPos, const D3DXVECTOR3& toWorldPos ) = 0;
		virtual void Picker_Update( const D3DXVECTOR3& eyePos, const D3DXVECTOR3& toWorldPos ) = 0;
		virtual void Picker_Release( void ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__WORLD, Mix::Tool::Win32::Object )
	};

}}}}
