#include "Mix/Tool/Win32/Core/File/OutputStream.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace File{

OutputStream::OutputStream( void ) :
m_hFile( INVALID_HANDLE_VALUE )
{
}

OutputStream::~OutputStream( void )
{
	Close();
}

bool OutputStream::Open( const wchar_t* pFileName )
{
	if( ( pFileName == NULL ) ||
		( ::wcslen( pFileName ) == 0 ) )
	{
		return false;
	}

	Close();

	m_hFile = ::CreateFileW( pFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if( m_hFile == INVALID_HANDLE_VALUE )
	{
		return false;
	}

	return true;
}

void OutputStream::Close( void )
{
	if( m_hFile != INVALID_HANDLE_VALUE )
	{
		::CloseHandle( m_hFile );
		m_hFile = INVALID_HANDLE_VALUE;
	}
}

bool OutputStream::Write( const void* pData, unsigned int dataSize )
{
	if( m_hFile == INVALID_HANDLE_VALUE )
	{
		return false;
	}

	DWORD writeSize = 0;

	if( ( ::WriteFile( m_hFile, pData, dataSize, &writeSize, NULL ) == FALSE ) ||
		( writeSize != dataSize ) )
	{
		return false;
	}

	return true;
}

Mix::Tool::Win32::Object::TYPE OutputStream::GetType( void ) const
{
	return Mix::Tool::Win32::Object::FILE__OUTPUT_STREAM;
}

}}}}
