#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace File{

	//e|Xg[NX
	class TemporaryStream : public Mix::Tool::Win32::Object
	{
	private:
		static const unsigned int DEF_SIZE;
		static const unsigned int RESIZE_STEP;

	private:
		std::wstring m_FilePath;
		unsigned char* m_pBuffer;
		unsigned int m_Size;
		unsigned int m_Pos;

	public:
		TemporaryStream( void );
		~TemporaryStream( void );

		bool Open( const wchar_t* pFilePath );
		bool Close( void );

		bool Write( const void* pData, unsigned int dataSize );
		void* Write( unsigned int dataSize );

		unsigned int GetSize( void ) const;

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
