#pragma once

////////////////////////////////////////////////////////////////////////////////////////////////////
// O
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class Material;
	class VertexLayout;
	class VertexShader;
	class PixelShader;
	class VertexBuffer;
	class IndexBuffer;

	//萔
	enum VALUE
	{
		MAX_VERTEX_WEIGHT = 4,	//_̍őEFCg

		MAX_NAME_SIZE = 32,		//O̍ő啶( NULL܂߂ )
	};

	//O̍ő啶( NULL܂߂Ȃ )
	const unsigned int _MAX_NAME_SIZE = ( MAX_NAME_SIZE - 1 );

	//o[ebNXGgZ}eBNX񋓒萔
	enum VERTEX_ELEMENT_SEMANTIC
	{
		VES_POSITION		= 0,
		VES_BLENDWEIGHT		= 1,
		VES_BLENDINDICES	= 2,
		VES_NORMAL			= 3,
		VES_PSIZE			= 4,
		VES_TEXTURE			= 5,
		VES_TANGENT			= 6,
		VES_BINORMAL		= 7,
		VES_COLOR			= 8,
	};

	//o[ebNXGgZ}eBNXő吔
	static const unsigned int VERTEX_ELEMENT_SEMANTIC_MAX = 9;

	//o[ebNXCAEgtH[}bg񋓒萔
	enum VERTEX_ELEMENT_FORMAT
	{
		VEF_FLOAT32_1	= 0,
		VEF_FLOAT32_2	= 1,
		VEF_FLOAT32_3	= 2,
		VEF_FLOAT32_4	= 3,
		VEF_UINT8_4		= 4,
		VEF_INT16_2		= 5,
		VEF_INT16_4		= 6,
		VEF_UINT8_4N	= 7,
		VEF_INT16_2N	= 8,
		VEF_INT16_4N	= 9,
		VEF_UINT16_2N	= 10,
		VEF_UINT16_4N	= 11,
		VEF_FLOAT16_2	= 12,
		VEF_FLOAT16_4	= 13,
	};

	//o[ebNXGgtH[}bgő吔
	static const unsigned int VERTEX_ELEMENT_FORMAT_MAX = 14;

	//o[ebNXGg\
	struct VERTEX_ELEMENT
	{
		unsigned int semanticType;
		unsigned int semanticIndex;
		unsigned int format;
		unsigned int offset;

		VERTEX_ELEMENT( void )
		{
			semanticType = 0;
			semanticIndex = 0;
			format = 0;
			offset = 0;
		}

		VERTEX_ELEMENT( unsigned int st, unsigned int si, unsigned int f, unsigned int o )
		{
			semanticType = st;
			semanticIndex = si;
			format = f;
			offset = o;
		}
	};

	//uh[h񋓒萔
	enum BLEND_MODE
	{
		BLEND_COPY		= 0,	//Rs[
		BLEND_NORMAL	= 1,	//ʏ
		BLEND_ADD		= 2,	//Z
		BLEND_SUB		= 3,	//Z
		BLEND_MUL		= 4,	//Z
		BLEND_SCREEN	= 5,	//XN[
	};

	//eNX`Xe[Wő吔
	static const unsigned int TEXTURE_STAGE_MAX = 8;

	//VF[_[f񋓒萔
	enum SHADER_MODEL
	{
		SHADER_MODEL_3 = 0x00000001,
		SHADER_MODEL_4 = 0x00000002,
		SHADER_MODEL_5 = 0x00000004,
	};

	//VF[_[vZXtO񋓒萔
	enum SHADER_PROCESS_FLAG
	{
		SHADER_PROCESS_FOG			= 0x00000001,
		SHADER_PROCESS_SHADOW		= 0x00000002,
		SHADER_PROCESS_REFRACT		= 0x00000004,
//		SHADER_PROCESS_SOFTPARTICLE	= 0x00000008,
//		SHADER_PROCESS_BLOOM		= 0x00000010,
//		SHADER_PROCESS_DOF			= 0x00000020,
		SHADER_PROCESS_ATMOSPHERE	= 0x00000040,
//		SHADER_PROCESS_LUMINANCE	= 0x00000080,
		SHADER_PROCESS_SSAO			= 0x00000100,
	};

	//VF[_[^Cv
	enum SHADER_TYPE
	{
		SHADER_NORMAL			= 0,	//ʏ
		SHADER_WATER			= 1,	//EH[^[
		SHADER_SHADELESS		= 2,	//CeBO
	};

	//fBt[Y^Cv
	enum DIFFUSE_TYPE
	{
		DIFFUSE_LAMBERT			= 0,	//o[g
		DIFFUSE_HALF_LAMBERT	= 1,	//n[to[g
	};

	//XyL[^Cv
	enum SPECULAR_TYPE
	{
		SPECULAR_NONE			= 0,	//
		SPECULAR_PHONG			= 1,	//tH
		SPECULAR_BLINN_PHONG	= 2,	//utH
		SPECULAR_COOK_TORRANCE	= 3,	//NbNgX
	};

	//tNg^Cv
	enum REFLECT_TYPE
	{
		REFLECT_NONE	= 0,	//
		REFLECT_NORMAL	= 1,	//ʏ
		REFLECT_FRESNEL	= 2,	//tl
	};

	//ov^Cv񋓒萔
	enum BUMP_TYPE
	{
		BUMP_NORMAL_MAPPING		= 0,
		BUMP_PARALLAX_MAPPING	= 1,
	};

	//EF[u^Cv
	enum WAVE_TYPE
	{
		WAVE_NORMAL		= 0,	// ʏ
		WAVE_REFRACT	= 1,	// ܌
	};

	//EF[u񋓒萔
	enum WAVE_DIR
	{
		WAVE_NEGATIVE_U = 0,	// eNX`Ԃ̍
		WAVE_POSITIVE_U = 1,	// eNX`Ԃ̉E
		WAVE_NEGATIVE_V = 2,	// eNX`Ԃ̏
		WAVE_POSITIVE_V = 3,	// eNX`Ԃ̉
	};

	//\bh񋓒萔
	enum TRANSPARENCY_METHOD
	{
		TRANSPARENCY_LUMP		= 0,	// ꊇ`
		TRANSPARENCY_INDIVIDUAL	= 1,	// |SPʂł̕`

		TRANSPARENCY_METHOD_MAX = 2,
	};

	//}eARpCtO񋓒萔
	enum MATERIAL_COMPILE_FLAG
	{
		MCF_NORMAL					= 0x00000001,
		MCF_TANGENT_SPACE			= 0x00000002,
		MCF_TEXTURE					= 0x00000004,

		MCF_SIMPLE_VERTEX			= 0x00000008,
		MCF_BLEND_VERTEX			= 0x00000010,

		MCF_LIGHTING				= 0x00000020,
		MCF_BOTH_LIGHTING			= 0x00000040,
		MCF_SHADOW_RECEIVE			= 0x00000080,

		MCF_REFRACT_CLIP			= 0x00000100,

		MCF_DIFFUSE_HALF_LAMBERT	= 0x00000200,
		MCF_DIFFUSE_MAPPING			= 0x00000400,
		MCF_DIFFUSE_FRESNEL			= 0x00000800,
		MCF_DIFFUSE_RIM_LIGHTING	= 0x00001000,

		MCF_SPECULAR_PHONG			= 0x00002000,
		MCF_SPECULAR_BLINN_PHONG	= 0x00004000,
		MCF_SPECULAR_COOK_TORRANCE	= 0x00008000,
		MCF_SPECULAR_MAPPING		= 0x00010000,

		MCF_REFLECT_MAPPING			= 0x00020000,
		MCF_REFLECT_FRESNEL			= 0x00040000,

		MCF_EMISSIVE_MAPPING		= 0x00080000,

		MCF_BUMP_MAPPING			= 0x00100000,
		MCF_PARALLAX				= 0x00200000,
		MCF_WATER					= 0x00400000,
		MCF_REFRACT_MAPPING			= 0x00800000,

		MCF_SOFTPARTICLE			= 0x01000000,

		MCF_WAVE_INVERT				= 0x02000000,

		MCF_ATMOSPHERE				= 0x10000000,
		MCF_FOG						= 0x20000000,
		MCF_SHADOW					= 0x40000000,
		MCF_SSAO					= 0x80000000,

		//}XN
		MCF_SIMPLE_MASK				=	0xFFFFFFEF, //~MCF_BLEND_VERTEX
		MCF_BLEND_MASK				=	0xFFFFFFF7, //~MCF_SIMPLE_VERTEX
		MCF_SPECULAR_MASK			=	MCF_SPECULAR_PHONG |
										MCF_SPECULAR_BLINN_PHONG |
										MCF_SPECULAR_COOK_TORRANCE |
										MCF_SPECULAR_MAPPING,

		//o[ebNXCAEgID}XN( RpCɂ͎gp܂ )
		MCF_ID_VERTEX_LAYOUT_MASK	=	MCF_NORMAL |
										MCF_TANGENT_SPACE |
										MCF_TEXTURE |
										MCF_SIMPLE_VERTEX |
										MCF_BLEND_VERTEX,

		//o[ebNXVF[_[ID}XN( RpCɂ͎gp܂ )
		MCF_ID_VERTEX_SHADER_MASK	=	MCF_NORMAL |
										MCF_TANGENT_SPACE |
										MCF_TEXTURE |
										MCF_SIMPLE_VERTEX |
										MCF_BLEND_VERTEX |
										MCF_LIGHTING |
										MCF_SHADOW_RECEIVE |
										MCF_BUMP_MAPPING |
										MCF_REFRACT_MAPPING |
										MCF_SSAO,

		//sNZVF[_[ID}XN( RpCɂ͎gp܂ )
		MCF_ID_PIXEL_SHADER_MASK	=	MCF_TEXTURE |
										MCF_LIGHTING |
										MCF_BOTH_LIGHTING |
										MCF_SHADOW_RECEIVE |
										MCF_REFRACT_CLIP |
										MCF_DIFFUSE_HALF_LAMBERT |
										MCF_DIFFUSE_MAPPING |
										MCF_DIFFUSE_FRESNEL |
										MCF_DIFFUSE_RIM_LIGHTING |
										MCF_SPECULAR_PHONG |
										MCF_SPECULAR_BLINN_PHONG |
										MCF_SPECULAR_COOK_TORRANCE |
										MCF_SPECULAR_MAPPING |
										MCF_REFLECT_MAPPING |
										MCF_REFLECT_FRESNEL |
										MCF_EMISSIVE_MAPPING |
										MCF_BUMP_MAPPING |
										MCF_PARALLAX |
										MCF_WATER |
										MCF_REFRACT_MAPPING |
										MCF_SOFTPARTICLE |
										MCF_WAVE_INVERT |
										MCF_ATMOSPHERE |
										MCF_FOG |
										MCF_SHADOW |
										MCF_SSAO, 
	};

	//o[ebNX^Cv
	enum VERTEX_TYPE
	{
		VERTEX_SIMPLE	= 0,
		VERTEX_BLEND	= 1,

		VERTEX_UNKNOWN	= 0xFFFFFFFF,	//s
	};

	//o[ebNX^Cvő吔
	static const unsigned int VERTEX_TYPE_MAX = 2;

	//}bsO^Cv
	enum MAPPING_TYPE
	{
		MAPPING_COLOR	= 0,	//J[
		MAPPING_MASK	= 1,	//}XN
	};

	//}bsO^Cvő吔
	static const unsigned int MAPPING_TYPE_MAX = 2;

	//CfbNX^Cv
	enum INDEX_TYPE
	{
		INDEX_USHORT	= 0,
		INDEX_UINT		= 1,

		INDEX_UNKNOWN	= 0xFFFFFFFF,	//s
	};

	//CfbNX^Cvő吔
	static const unsigned int INDEX_TYPE_MAX = 2;

	//Co[ebNX\
	struct LINE_VERTEX
	{
		D3DXVECTOR4 pos;
		D3DXVECTOR4 color;

		LINE_VERTEX( void ) {}
		LINE_VERTEX( const D3DXVECTOR4& p, const D3DXVECTOR4& c )
		{
			pos = p;
			color = c;
		}
	};

	//Nbho[ebNX\
	struct QUAD_VERTEX
	{
		D3DXVECTOR4 pos;
		D3DXVECTOR2 tex;

		QUAD_VERTEX( void )
		{
			pos = D3DXVECTOR4( 0.0f, 0.0f, 0.0f, 1.0f );
			tex = D3DXVECTOR2( 0.0f, 0.0f );
		}

		QUAD_VERTEX( float x, float y, float u, float v )
		{
			pos.x = x;
			pos.y = y;
			pos.z = 0.0f;
			pos.w = 1.0f;

			tex.x = u;
			tex.y = v;
		}
	};

	//o[ebNXVF[_[̃WX^
	enum VSR
	{
		VSR_V_MAT			= 16,
		VSR_VP_MAT			= 20,
		VSR_WORLD_MAT		= 32,
	};
	
	//sNZVF[_[̃WX^
	enum PSR
	{
		PSR_CAMERA_INV_FARZ		= 16,
		PSR_EYE_POS				= 17,

		PSR_AMBIENT_LIGHT_COLOR	= 18,

		PSR_HS_LIGHT_AXIS		= 19,

		PSR_SUN_LIGHT_DIR		= 22,
		PSR_SUN_LIGHT_COLOR		= 23,

		PSR_FOG_PARAM			= 24,

		PSR_SHADOW_PARAM		= 26,

		PSR_LOCAL_LIGHT			= 48,

		PSR_AMBIENT_COLOR		= 68,
		PSR_DIFFUSE_COLOR		= 69,
		PSR_DIFFUSE_PARAM		= 70,
		PSR_SPEUCLAR_COLOR		= 71,
		PSR_SPEUCLAR_PARAM0		= 72,
		PSR_SPEUCLAR_PARAM1		= 73,
		PSR_REFLECT_PARAM		= 74,
		PSR_EMISSIVE_COLOR		= 75,
		PSR_EMISSIVE_PARAM		= 76,
		PSR_BUMP_PARAM0			= 77,
		PSR_BUMP_PARAM1			= 78,
		PSR_TRANSPARENCY_PARAM	= 79,
	};

	//eNX`Xe[W
	enum TS
	{
		TS_DIFFUSE_TEXTURE		= 0,
		TS_SPEUCLAR_TEXTURE		= 1,
		TS_EMISSIVE_TEXTURE		= 2,
		TS_BUMP_TEXTURE			= 3,

		TS_DEPTH_TEXTURE		= 4,
		TS_SHADOW_TEXTURE		= 5,
		TS_REFRACT_TEXTURE		= 6,
		TS_REFRECT_TEXTURE		= 7,
	};

	//ʍ\
	struct PLANE
	{
		D3DXVECTOR3 normal;
		float d;

		static void Compute(	const D3DXVECTOR3& p0,
								const D3DXVECTOR3& p1,
								const D3DXVECTOR3& p2,
								PLANE& plane )
		{
			D3DXVECTOR3 v1;
			D3DXVECTOR3 v2;

			v1 = ( p1 - p0 );
			v2 = ( p2 - p0 );

			D3DXVec3Cross( &( plane.normal ), &v1, &v2 );
			D3DXVec3Normalize( &( plane.normal ), &( plane.normal ) );

			plane.d = -D3DXVec3Dot( &( plane.normal ), &p0 );
		}
	};

	//EFCg\
	struct WEIGHT
	{
		unsigned int index;
		float value;

		WEIGHT( void ) :
		index( 0 ),
		value( 0.0f )
		{
		}

		bool operator()( const WEIGHT& l, const WEIGHT& r )
		{
			return ( l.value > r.value );
		}
	};

	//o[ebNX\
	struct VERTEX
	{
		D3DXVECTOR3 pos;
		D3DXVECTOR4 color;
		D3DXVECTOR3 normal;
		D3DXVECTOR2 tex;
		Mix::Tool::Win32::Graphics::WEIGHT weights[Mix::Tool::Win32::Graphics::MAX_VERTEX_WEIGHT];
	};

	//uNo[ebNX\
	struct BLANK_VERTEX
	{
		D3DXVECTOR3 pos;
		unsigned int indices[Mix::Tool::Win32::Graphics::MAX_VERTEX_WEIGHT];
		float weights[Mix::Tool::Win32::Graphics::MAX_VERTEX_WEIGHT];
	};

	//|S\
	struct POLYGON
	{
		unsigned int materialNo;
		std::vector<Mix::Tool::Win32::Graphics::VERTEX> vertices;

		bool operator()( const Mix::Tool::Win32::Graphics::POLYGON& l, const Mix::Tool::Win32::Graphics::POLYGON& r )
		{
			return ( l.materialNo < r.materialNo );
		}
	};

	//x[XVFCv\
	struct BASE_SHAPE
	{
		std::wstring name;
		Mix::Tool::Win32::Geometry::OBB obb;

		bool operator()( const Mix::Tool::Win32::Graphics::BASE_SHAPE& l, const Mix::Tool::Win32::Graphics::BASE_SHAPE& r )
		{
			return ( l.name < r.name );
		}
	};

	//rh^Cv񋓒萔
	enum MESH_BUILD_TYPE
	{
		MESH_BUILD_DIRECT	= 0,	// œKȂ
		MESH_BUILD_OPTIMIZE	= 1,	// œK
	};

	//{[\
	struct BONE
	{
		std::wstring name;
		D3DXMATRIX offsetMatrix;
	};

	//J[uL[\
	struct CURVE_KEY
	{
		int time;
		float value;
	};

	//NH[^jIL[
	struct QUATERNION_KEY
	{
		float time;
		D3DXQUATERNION value;

		QUATERNION_KEY( void )
		{
			time = 0.0f;
			D3DXQuaternionIdentity( &value );
		}

		QUATERNION_KEY( const D3DXQUATERNION& _value )
		{
			time = 0.0f;
			value = _value;
		}

		QUATERNION_KEY( float _time, const D3DXQUATERNION& _value )
		{
			time = _time;
			value = _value;
		}

		bool operator () ( const QUATERNION_KEY& l, const QUATERNION_KEY& r )
		{
			return l.time < r.time;
		}

		bool operator () ( const float& l, const QUATERNION_KEY& r )
		{
			return l < r.time;
		}

		bool operator () ( const QUATERNION_KEY& l, const float& r )
		{
			return l.time < r;
		}
	};

	//NH[^jIL[Xg
	typedef std::vector<Mix::Tool::Win32::Graphics::QUATERNION_KEY> QuaternionKeyList;

	//xN^[L[
	struct VECTOR_KEY
	{
		float time;
		D3DXVECTOR3 value;

		VECTOR_KEY( void )
		{
			time = 0.0f;
			value = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
		}

		VECTOR_KEY( const D3DXVECTOR3& _value )
		{
			time = 0.0f;
			value = _value;
		}

		VECTOR_KEY( float _time, const D3DXVECTOR3& _value )
		{
			time = _time;
			value = _value;
		}

		bool operator () ( const VECTOR_KEY& l, const VECTOR_KEY& r )
		{
			return l.time < r.time;
		}

		bool operator () ( const float& l, const VECTOR_KEY& r )
		{
			return l < r.time;
		}

		bool operator () ( const VECTOR_KEY& l, const float& r )
		{
			return l.time < r;
		}
	};

	//xN^[L[Xg
	typedef std::vector<Mix::Tool::Win32::Graphics::VECTOR_KEY> VectorKeyList;

	//[ggXtH[uh\
	struct RT_BLEND
	{
		unsigned int priority;
		float ratio;
		D3DXQUATERNION angularVelocity;
		D3DXVECTOR3 linearVelocity;

		bool operator()( const Mix::Tool::Win32::Graphics::RT_BLEND& l, const Mix::Tool::Win32::Graphics::RT_BLEND& r )
		{
			return ( l.priority < r.priority );
		}
	};

	//{fBgXtH[uh\
	struct BT_BLEND
	{
		unsigned int priority;
		unsigned int nodeIndex;
		float ratio;
		D3DXVECTOR3 scaling;
		D3DXQUATERNION rotation;
		D3DXVECTOR3 translation;

		bool operator()( const Mix::Tool::Win32::Graphics::BT_BLEND& l, const Mix::Tool::Win32::Graphics::BT_BLEND& r )
		{
			return ( l.priority < r.priority );
		}
	};

	//[V : [ggXtH[ : tO񋓒萔
	enum MOTION_ROOT_TRANSFORM_FLAG
	{
		MOTION_RT_ROTATION			= 0x00000001,	//]

		MOTION_RT_TRANSLATION_XZ	= 0x00000002,	//ړ(XZ)
		MOTION_RT_TRANSLATION_Y		= 0x00000004,	//ړ(Y)
		MOTION_RT_TRANSLATION		= 0x00000006,	//ړ

		MOTION_RT_MASK				= 0x00000007,	//}XN
	};

	//[V : [ggXtH[ : ʗ񋓒萔
	enum MOTION_RT_HORIZONAL
	{
		MOTION_RT_H_XY	= 0,	//XY
		MOTION_RT_H_XZ	= 1,	//XZ
		MOTION_RT_H_YZ	= 2,	//YZ
	};

	//[V : [ggXtH[ : 񋓒萔
	enum MOTION_RT_VERTICAL
	{
		MOTION_RT_V_X	= 0,	//X
		MOTION_RT_V_Y	= 1,	//Y
		MOTION_RT_V_Z	= 2,	//Z
	};

	//[V : [ggXtH[ : xN^[񋓒萔
	enum MOTION_RT_VECTOR
	{
		MOTION_RT_NEGATIVE_X	= 0,	//-X
		MOTION_RT_POSITIVE_X	= 1,	//+X
		MOTION_RT_NEGATIVE_Y	= 2,	//-Y
		MOTION_RT_POSITIVE_Y	= 3,	//+Y
		MOTION_RT_NEGATIVE_Z	= 4,	//-Z
		MOTION_RT_POSITIVE_Z	= 5,	//+Z
	};

	//[V : [ggXtH[ANVY\
	struct MOTION_RT_AXIS
	{
		MOTION_RT_VECTOR x;
		MOTION_RT_VECTOR y;
		MOTION_RT_VECTOR z;

		MOTION_RT_AXIS( void )
		{
			x = MOTION_RT_POSITIVE_X;
			y = MOTION_RT_POSITIVE_Y;
			z = MOTION_RT_POSITIVE_Z;
		}

		MOTION_RT_AXIS( MOTION_RT_VECTOR _x, MOTION_RT_VECTOR _y, MOTION_RT_VECTOR _z )
		{
			x = _x;
			y = _y;
			z = _z;
		}

		bool operator != ( const MOTION_RT_AXIS& r ) const
		{
			if( ( x != r.x ) ||
				( y != r.y ) ||
				( z != r.z ) )
			{
				return true;
			}

			return false;
		}
	};

	//[V : Xe[g񋓒萔
	enum MOTION_STATE
	{
		MOTION_PLAY = 0,	//Đ
		MOTION_PAUSE = 1,	//ꎞ~
		MOTION_STOP	= 2,	//~
	};

	//x[XTuZbg\
	struct BASE_SUBSET
	{
		unsigned int boneCount;
		const D3DXMATRIX* boneMatTable;

		unsigned int vertexStart;
		unsigned int vertexNum;
		unsigned int indexStart;
		unsigned int indexNum;

		Mix::Tool::Win32::Graphics::VertexLayout* pCommonVL;

		Mix::Tool::Win32::Graphics::VertexShader* pColorVS;
		Mix::Tool::Win32::Graphics::PixelShader* pColorPS;

		Mix::Tool::Win32::Graphics::VertexBuffer* pVertexBuffer;
		Mix::Tool::Win32::Graphics::IndexBuffer* pIndexBuffer;
	};

	//J[TuZbg\
	struct COLOR_SUBSET : public BASE_SUBSET
	{
		Mix::Tool::Win32::Graphics::Material* pMaterial;

		Mix::Tool::Win32::Graphics::VertexShader* pSelectVS;
		Mix::Tool::Win32::Graphics::PixelShader* pSelectPS;

		D3DXVECTOR4 selectColor;
	};

	//sTuZbg\
	struct OPACITY_SUBSET : public COLOR_SUBSET
	{
		unsigned int sortKey;

		bool operator()( const OPACITY_SUBSET& l, const OPACITY_SUBSET& r )
		{
			return ( l.sortKey < r.sortKey );
		}
	};

	//TuZbg\
	struct TRANSPARENCY_SUBSET : public COLOR_SUBSET
	{
		D3DXVECTOR4 sortKey;

		bool operator()( const TRANSPARENCY_SUBSET& l, const TRANSPARENCY_SUBSET& r )
		{
			return ( l.sortKey.z > r.sortKey.z );
		}
	};

	//tNgTuZbg\
	struct REFRACT_SUBSET : public COLOR_SUBSET
	{
		Mix::Tool::Win32::Graphics::VertexShader* pMaskVS;
		Mix::Tool::Win32::Graphics::PixelShader* pMaskPS;

		unsigned int sortKey;

		bool operator()( const REFRACT_SUBSET& l, const REFRACT_SUBSET& r )
		{
			return ( l.sortKey < r.sortKey );
		}
	};

	// : }eA\
	struct PHYSICS_MATERIAL
	{
		int id;
		int attr;
		float friction;
		float restitution;
	};

	// : Wbh{fB\
	struct PHYSICS_RIGIDBODY
	{
		float mass;
		float gravityAcceleration;
		float linearDamping;
		float angularDamping;
	};

}}}}
