#include "Mix/Tool/Win32/Core/Graphics/BackBuffer.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

BackBuffer* BackBuffer::CreateInstance( void )
{
	return new BackBuffer();
}

BackBuffer::BackBuffer( void ) :
m_pD3DSurface( NULL )
{
	ZeroMemory( &m_D3DDesc, sizeof( m_D3DDesc ) );
}

BackBuffer::~BackBuffer( void )
{
	MIX_RELEASE( m_pD3DSurface );
}

void BackBuffer::SetSurface( IDirect3DSurface9* pD3DSurface )
{
	MIX_RELEASE( m_pD3DSurface );
	MIX_ADD_REF( pD3DSurface );
	m_pD3DSurface = pD3DSurface;

	if( m_pD3DSurface != NULL )
	{
		pD3DSurface->GetDesc( &m_D3DDesc );
	}
}

unsigned int BackBuffer::GetWidth( void ) const
{
	return m_D3DDesc.Width;
}

unsigned int BackBuffer::GetHeight( void ) const
{
	return m_D3DDesc.Height;
}

D3DFORMAT BackBuffer::GetFormat( void ) const
{
	return m_D3DDesc.Format;
}

IDirect3DBaseTexture9* BackBuffer::GetTexturePtr( void )
{
	return NULL;
}

IDirect3DSurface9* BackBuffer::GetSurfacePtr( void )
{
	return m_pD3DSurface;
}

void BackBuffer::OnInvalidate( void )
{
}

void BackBuffer::OnValidate( void )
{
}

Mix::Tool::Win32::Object::TYPE BackBuffer::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__BACK_BUFFER;
}

}}}}
