#pragma once

#include "Mix/Tool/Win32/Core/Graphics/Texture.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class BackBuffer : public Mix::Tool::Win32::Graphics::Texture
	{
	public:
		static BackBuffer* CreateInstance( void );

	private:
		IDirect3DSurface9* m_pD3DSurface;
		D3DSURFACE_DESC m_D3DDesc;

	private:
		BackBuffer( void );
		virtual ~BackBuffer( void );

	public:
		void SetSurface( IDirect3DSurface9* pD3DSurface );

	public:
		virtual unsigned int GetWidth( void ) const;
		virtual unsigned int GetHeight( void ) const;
		virtual D3DFORMAT GetFormat( void ) const;

		virtual IDirect3DBaseTexture9* GetTexturePtr( void );
		virtual IDirect3DSurface9* GetSurfacePtr( void );

	public:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
