#pragma once

#include "Mix/Tool/Win32/Core/Graphics/SceneObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class DrawObject;
	class TargetTexture;
	class SwapChain;

	class Camera : public Mix::Tool::Win32::Graphics::SceneObject
	{
	public:
		enum DRAW_FLAG
		{
			DRAW_GRID					= 0x00000001,
			DRAW_LIGHT					= 0x00000002,

			DRAW_BODY					= 0x00000004,
			DRAW_VIEWVOLUME				= 0x00000008,
			DRAW_BONE					= 0x00000010,

			DRAW_KINEMATIC_CHARACTER	= 0x00000020,
			DRAW_COLLISION				= 0x00000040,
			DRAW_JOINT					= 0x00000080,

			DRAW_FRAMES_PER_SEC			= 0x00000100,
			DRAW_PRIMITIVE_COUNT		= 0x00000200,

			DRAW_DEF					= 0x00000007,
			DRAW_ALL					= 0x000003FF,

			DRAW_TEXT_MASK				= 0x00000300,
		};

	private:
		enum FP_TYPE
		{
			FP_NEAR		= 0,
			FP_FAR		= 1,
			FP_LEFT		= 2,
			FP_RIGHT	= 3,
			FP_TOP		= 4,
			FP_BOTTOM	= 5,

			FP_TYPE_MAX	= 6,
		};

	private:
		static const float DEF_DISTANCE;
		static const float DEF_ROTATION_H;
		static const float DEF_ROTATION_V;

	private:
		Mix::Tool::Win32::Graphics::TargetTexture* m_pSelectMapTex;
		Mix::Tool::Win32::Graphics::SwapChain* m_pSwapChain;

		float m_DefDistance;
		float m_Distance;

		D3DXVECTOR3 m_LocalPosition;
		D3DXVECTOR3 m_Target;

		D3DXMATRIX m_PoseMatrix;
		D3DXMATRIX m_ViewMatrix;
		D3DXMATRIX m_ViewProjMatrix;
		D3DXQUATERNION m_PoseQuat;

		D3DXVECTOR3 m_Position;
		D3DXVECTOR3 m_Direction;

		D3DFILLMODE m_FillMode;

		bool m_bInvisibleSelection;
/*
		D3DXVECTOR3 m_DrawObjectScaling;
		D3DXVECTOR2 m_DrawObjectScalingBasePos;
		float m_InvDrawObjectScalingLength;
*/
		unsigned int m_DrawFlags;

		D3DXPLANE m_Frustum[Camera::FP_TYPE_MAX];

	private:
		void RotationDirect( const D3DXVECTOR3& rot );

		D3DXMATRIX RotationMatrix( const D3DXMATRIX& mat, int h, int v );

		void DistationLocalPosition( void );
		void RotationLocalPosition( const D3DXVECTOR3& axis, const D3DXVECTOR3& diff );

		void SetPoseMatrix( const D3DXVECTOR3& rot );

		bool IsActive( void );
		void Update( void );

		Mix::Tool::Win32::Graphics::TargetTexture* GetSelectMapTexPtr( void );
		Mix::Tool::Win32::Graphics::SwapChain* GetSwapChainPtr( void );

	public:
		Camera( void );
		virtual~Camera( void );

		bool Initialize( HWND hWnd );

		void SetParam( const D3DXVECTOR3& localPos, const D3DXVECTOR3& target, const D3DXQUATERNION& pose );

		void SetDefDistance( float d );
		float GetDefDistance( void ) const;

		void SetDistance( float d );
		float GetDistance( void ) const;

		void SetPose( const D3DXQUATERNION& quat );
		const D3DXQUATERNION& GetPose( void ) const;

		void SetTarget( const D3DXVECTOR3& pos );
		const D3DXVECTOR3& GetTarget( void ) const;

		void ResetDistation( void );
		void Distation( int d );
		
		void ResetRotation( void );
		void Rotation( int h, int v );

		void ResetTranslation( void );
		void Translation( int h, int v );

		void SetInvisibleSelection( bool state );
		bool GetInvisibleSelection( void ) const;

		void SetFillMode( D3DFILLMODE fill );
		D3DFILLMODE GetFillMode( void ) const;

		void SetDrawFlags( unsigned int flags );
		unsigned int GetDrawFlags( void ) const;

		void RotationLight( int h, int v );
/*
		bool SetupScalingDrawObject( const POINT& pos );
		void ScalingDrawObject( const POINT& pos );

		void RotationDrawObject( int h, int v );

		void TranslationDrawObject( int h, int v );
*/
		unsigned int SelectMesh( const POINT& pos );

		D3DXVECTOR3 Unproject( const D3DXVECTOR3& pos );	//xy ̓XN[ԁAz ͎ˉe( 0.0f ` 1.0f )Ŏw肷

		const D3DXVECTOR3& GetLocalPosition( void ) const;
		const D3DXVECTOR3& GetPosition( void ) const;
		const D3DXVECTOR3& GetDirection( void ) const;

		const D3DXMATRIX& GetViewMatrix( void ) const;
		const D3DXMATRIX& GetViewProjMatrix( void ) const;

	public:
		bool Contains( const Mix::Tool::Win32::Geometry::SPHERE& sphere ) const;
		bool Contains( const Mix::Tool::Win32::Geometry::AABB& aabb ) const;

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
		virtual bool QueryType( Mix::Tool::Win32::Object::TYPE type ) const;

		friend class Scene;
		friend class Manager;
	};

}}}}
