#include "Mix/Tool/Win32/Core/Graphics/CubeTexture.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

CubeTexture* CubeTexture::CreateInstance( void )
{
	return new CubeTexture();
}

CubeTexture::CubeTexture( void ) :
m_pD3DTexture( NULL )
{
	::ZeroMemory( &m_D3DDesc, sizeof( m_D3DDesc ) );
}

CubeTexture::~CubeTexture( void )
{
	MIX_RELEASE( m_pD3DTexture );
}

void* CubeTexture::AllocateBuffer( unsigned int size )
{
	m_Buffer.resize( size, 0 );

	return &( m_Buffer[0] );
}

unsigned int CubeTexture::GetBufferSize( void ) const
{
	return m_Buffer.size();
}

unsigned int CubeTexture::GetWidth( void ) const
{
	return m_D3DDesc.Width;
}

unsigned int CubeTexture::GetHeight( void ) const
{
	return m_D3DDesc.Height;
}

D3DFORMAT CubeTexture::GetFormat( void ) const
{
	return m_D3DDesc.Format;
}

IDirect3DBaseTexture9* CubeTexture::GetTexturePtr( void )
{
	return m_pD3DTexture;
}

IDirect3DSurface9* CubeTexture::GetSurfacePtr( void )
{
	return NULL;
}

void CubeTexture::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DTexture );
}

void CubeTexture::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DTexture = pManager->D3D_CreateCubeTexture( &( m_Buffer[0] ), m_Buffer.size(), m_D3DDesc );
}

Mix::Tool::Win32::Object::TYPE CubeTexture::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__CUBE_TEXTURE;
}

}}}}
