#include "Mix/Tool/Win32/Core/Graphics/FileTexture.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

FileTexture* FileTexture::CreateInstance( const wchar_t* pFileName )
{
	return new FileTexture( pFileName );
}

FileTexture::FileTexture( const wchar_t* pFileName ) :
m_pD3DTexture( NULL )
{
	m_FileName = pFileName;

	ZeroMemory( &m_D3DDesc, sizeof( m_D3DDesc ) );
}

FileTexture::~FileTexture( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();

	if( pManager != NULL )
	{
		pManager->RemoveTexture( m_FileName.c_str() );
	}

	MIX_RELEASE( m_pD3DTexture );
}

const wchar_t* FileTexture::GetFileName( void ) const
{
	return m_FileName.c_str();
}

unsigned int FileTexture::GetWidth( void ) const
{
	return m_D3DDesc.Width;
}

unsigned int FileTexture::GetHeight( void ) const
{
	return m_D3DDesc.Height;
}

D3DFORMAT FileTexture::GetFormat( void ) const
{
	return m_D3DDesc.Format;
}

const void* FileTexture::GetBuffer( void ) const
{
	return ( m_Buffer.size() > 0 )? &( m_Buffer[0] ) : NULL;
}

unsigned int FileTexture::GetBufferSize( void ) const
{
	return m_Buffer.size();
}

void* FileTexture::AllocateBuffer( unsigned int size )
{
	m_Buffer.resize( size );
	return ( m_Buffer.size() > 0 )? &( m_Buffer[0] ) : NULL;
}

IDirect3DBaseTexture9* FileTexture::GetTexturePtr( void )
{
	return m_pD3DTexture;
}

IDirect3DSurface9* FileTexture::GetSurfacePtr( void )
{
	return NULL;
}

void FileTexture::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DTexture );
}

void FileTexture::OnValidate( void )
{
	if( m_Buffer.size() == 0 )
	{
		return;
	}

	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DTexture = pManager->D3D_CreateTexture( m_FileName.c_str(), &( m_Buffer[0] ), m_Buffer.size(), m_D3DDesc );
}

Mix::Tool::Win32::Object::TYPE FileTexture::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__FILE_TEXTURE;
}

}}}}
