#pragma once

#include <string>
#include <vector>

#include "Mix/Tool/Win32/Core/Graphics/Texture.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class FileTexture : public Mix::Tool::Win32::Graphics::Texture
	{
	private:
		std::wstring m_FileName;
		std::vector<unsigned char> m_Buffer;
		IDirect3DTexture9* m_pD3DTexture;
		D3DSURFACE_DESC m_D3DDesc;

	public:
		static FileTexture* CreateInstance( const wchar_t* pFileName );

	private:
		FileTexture( const wchar_t* pFileName );
		virtual ~FileTexture( void );

		void* AllocateBuffer( unsigned int size );

	public:
		const wchar_t* GetFileName( void ) const;
		const void* GetBuffer( void ) const;
		unsigned int GetBufferSize( void ) const;

	public:
		virtual unsigned int GetWidth( void ) const;
		virtual unsigned int GetHeight( void ) const;
		virtual D3DFORMAT GetFormat( void ) const;

		virtual IDirect3DBaseTexture9* GetTexturePtr( void );
		virtual IDirect3DSurface9* GetSurfacePtr( void );

	public:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
