#include "Mix/Tool/Win32/Core/Graphics/IndexBuffer.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

IndexBuffer* IndexBuffer::CreateInstance( D3DFORMAT format, unsigned int count, unsigned int size, const void* initialData )
{
	return new IndexBuffer( format, count, size, initialData );
}

IndexBuffer::IndexBuffer( D3DFORMAT format, unsigned int count, unsigned int size, const void* initialData ) :
m_pD3DBuffer( NULL )
{
	m_bLock = false;
	m_D3DFormat = format;
	m_Count = count;
	m_Size = size;

	m_Buffer.resize( m_Size, 0 );

	if( initialData != NULL )
	{
		::CopyMemory( &( m_Buffer[0] ), initialData, m_Size );
	}
}

IndexBuffer::~IndexBuffer( void )
{
	MIX_RELEASE( m_pD3DBuffer );
}

void* IndexBuffer::Lock( void )
{
	if( m_bLock == true )
	{
		return NULL;
	}

	m_bLock = true;

	return &( m_Buffer[0] );
}

void IndexBuffer::Unlock( void )
{
	if( m_bLock == false )
	{
		return;
	}

	if( m_pD3DBuffer != NULL )
	{
		unsigned char* pDst = NULL;

		if( m_pD3DBuffer->Lock( 0, 0, reinterpret_cast<void**>( &pDst ), 0 ) == D3D_OK )
		{
			::CopyMemory( pDst, &( m_Buffer[0] ), m_Size );

			m_pD3DBuffer->Unlock();
		}
	}

	m_bLock = false;
}

unsigned int IndexBuffer::GetStride( void ) const
{
	return ( m_D3DFormat == D3DFMT_INDEX16 )? 2 : 4;
}

unsigned int IndexBuffer::GetCount( void ) const
{
	return m_Count;
}

const void* IndexBuffer::GetBuffer( void ) const
{
	return ( m_Buffer.size() > 0 )? &( m_Buffer[0] ) : NULL;
}

unsigned int IndexBuffer::GetBufferSize( void ) const
{
	return m_Buffer.size();
}

IDirect3DIndexBuffer9* IndexBuffer::GetInterfacePtr( void )
{
	return m_pD3DBuffer;
}

void IndexBuffer::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DBuffer );
}

void IndexBuffer::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	unsigned char* pDst = NULL;

	m_pD3DBuffer = pManager->D3D_CreateIndexBuffer( m_D3DFormat, m_Size );

	if( ( m_pD3DBuffer != NULL ) &&
		( m_pD3DBuffer->Lock( 0, 0, reinterpret_cast<void**>( &pDst ), 0 ) == D3D_OK ) )
	{
		::CopyMemory( pDst, &( m_Buffer[0] ), m_Size );

		m_pD3DBuffer->Unlock();
	}
}

Mix::Tool::Win32::Object::TYPE IndexBuffer::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__INDEX_BUFFER;
}

}}}}
