#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Graphics/DeviceObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class IndexBuffer : public Mix::Tool::Win32::Graphics::DeviceObject
	{
	private:
		IDirect3DIndexBuffer9* m_pD3DBuffer;
		std::vector<unsigned char> m_Buffer;

		D3DFORMAT m_D3DFormat;
		unsigned int m_Count;
		unsigned int m_Size;
		bool m_bLock;

	public:
		static IndexBuffer* CreateInstance( D3DFORMAT format, unsigned int count, unsigned int size, const void* initialData );

	private:
		IndexBuffer( D3DFORMAT format, unsigned int count, unsigned int size, const void* initialData );
		virtual ~IndexBuffer( void );

		IDirect3DIndexBuffer9* GetInterfacePtr( void );

	public:
		MIX_REFERENCE_METHOD

	public:
		void* Lock( void );
		void Unlock( void );

		unsigned int GetStride( void ) const;
		unsigned int GetCount( void ) const;

		const void* GetBuffer( void ) const;
		unsigned int GetBufferSize( void ) const;

	public:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
