#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class LineHelper : public Mix::Tool::Win32::Object
	{
	private:
		unsigned int m_TransformStart;
		D3DXVECTOR4 m_Color;
		D3DXMATRIX m_Mat;
		std::vector<Mix::Tool::Win32::Graphics::LINE_VERTEX> m_VertexList;

		std::vector<D3DXVECTOR3> m_SphereLineTable;
		std::vector<D3DXVECTOR3> m_HemisphereLineTable;
		std::vector<D3DXVECTOR3> m_CylinderLineTable;

	public:
		LineHelper( void );
		virtual ~LineHelper( void );

	private:
		void Transform( bool bExcludeScaing = false );

	public:
		void Clear( void );

		void IdentityColor( void );
		void SetColor( const D3DXVECTOR4& color );
		const D3DXVECTOR4& GetColor( void ) const;

		void IdentityMatrix( void );
		void SetMatrix( const D3DXMATRIX& mat );
		const D3DXMATRIX& GetMatrix( void ) const;

		void AddPoints( const D3DXVECTOR3& p0, const D3DXVECTOR3& p1 );
		void AddPoints( const D3DXVECTOR3* points, unsigned int count );
		void AddBox( const D3DXVECTOR3& halfExtents );
		void AddCapsule( const Mix::Tool::Win32::Geometry::CAPSULE& capsule );
		void AddSphere( const Mix::Tool::Win32::Geometry::SPHERE& sphere );
		void AddAABB( const Mix::Tool::Win32::Geometry::AABB& aabb );
		void AddOBB( const Mix::Tool::Win32::Geometry::OBB& obb );
		void AddAxis( const D3DXVECTOR3& pos, float scale );
		void AddAxis( const D3DXVECTOR3& pos, const D3DXVECTOR3& scale );
		void AddAxis( const D3DXVECTOR3& pos, const D3DXVECTOR3 axis[3], const D3DXVECTOR3& scale );

		const std::vector<Mix::Tool::Win32::Graphics::LINE_VERTEX>& GetVertexList( void ) const;

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
