#pragma once

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	//MAM萔
	enum MAM_VALUE
	{
		//t@Cwb_
		MAM_MAGICNUMBER		= 0x464D414D, //MAMF
		MAM_VERSION_1_0_0_0 = 0x01000000,
		MAM_VERSION			= MAM_VERSION_1_0_0_0,

		//Ct[ : Wn
		MAM_CS_LH = 1,	//Wn
		MAM_CS_RH = 2,	//EWn

		//VFCv
		MAM_BOX_SHAPE		= 1,
		MAM_CAPSULE_SHAPE	= 2,
		MAM_SPHERE_SHAPE	= 3,

		//
		MAM_AXIS_X = 1,
		MAM_AXIS_Y = 2,
		MAM_AXIS_Z = 3,

		//RC_[(Xe[^X)
		MAM_CS_DEFAULT			= 1,
		MAM_CS_STATIC			= 2,
		MAM_CS_KINEMATIC		= 3,

		//RC_[(tO)
		MAM_CF_ROT_X			= 0x00000001,
		MAM_CF_ROT_Y			= 0x00000002,
		MAM_CF_ROT_Z			= 0x00000004,
		MAM_CF_ALWAYS_ACTIVE	= 0x00000008,
		MAM_CF_CAST_MOTION		= 0x00000010,

		//WCg
		MAM_POINT_JOINT	= 1,
		MAM_HINGE_JOINT	= 2,
		MAM_BALL_JOINT	= 3,

		//WCgtO
		MAM_JF_COLLISION_DISABLE = 0x00000001,
	};

	//MAMt@Cwb_\
	struct MAM_FILE_HEADER_1_0_0_0
	{
		unsigned int magicNumber;
		unsigned int version;
	};

	//MAMf[^wb_\
	struct MAM_DATA_HEADER_1_0_0_0
	{
		unsigned int materialNum;
		unsigned int meshNum;
		unsigned int motionControllerNum;
		unsigned int kinematicCharacterNum;
		unsigned int shapeNum;
		unsigned int colliderNum;
		unsigned int sensorNum;
		unsigned int jointNum;
		unsigned int mainFrameNum;
		unsigned int nodeNum;
	};

	//MAMLl}eBbNLN^[\
	struct MAM_KINEMATIC_CHARACTER_1_0_0_0
	{
		float loadMat[4][4];
		float storeMat[4][4];
		float height;
		float radius;
		float garvity;
		float maxFallSpeed;
		float initJumpSpeed;
		float stepHeight;
		float slopeLimit;
		unsigned int reserve;
	};

	//MAMVFCv\
	struct MAM_SHAPE_1_0_0_0
	{
		float localRotation[4];
		float localPosition[4];
		unsigned int type;
		unsigned int data[5];
	};

	//MAM{bNXVFCv\
	struct MAM_BOX_SHAPE_DATA_1_0_0_0
	{
		float halfExtents[3];

		unsigned int reserve[2];
	};

	//MAMJvZVFCv\
	struct MAM_CAPSULE_SHAPE_DATA_1_0_0_0
	{
		unsigned int axis;
		float length;
		float radius;

		unsigned int reserve[2];
	};

	//MAMXtBAVFCv\
	struct MAM_SPHERE_SHAPE_DATA_1_0_0_0
	{
		float radius;

		unsigned int reserve[4];
	};

	//MAMRC_[\
	struct MAM_COLLIDER_1_0_0_0
	{
		wchar_t name[Mix::Tool::Win32::Graphics::MAX_NAME_SIZE];
		unsigned int shapeNum;
		unsigned int id;
		unsigned int attr;
		float friction;
		float restitution;
		unsigned int status;
		float mass;
		unsigned int flags;
		float centerMatrix[4][4];
		float restoreMatrix[4][4];
		float rotation[4];
		float position[4];
	};

	//MAMZT[\
	struct MAM_SENSOR_1_0_0_0
	{
		wchar_t name[Mix::Tool::Win32::Graphics::MAX_NAME_SIZE];
		unsigned int shapeNum;
		unsigned int id;
		unsigned int attr;
		unsigned int reserve;
		float centerMatrix[4][4];
		float rotation[4];
		float position[4];
	};

	//MAMWCg\
	struct MAM_JOINT_1_0_0_0
	{
		unsigned int type;
		unsigned int flags;
		int colliderA;
		int colliderB;
		float pivotA[4];
		float pivotB[4];
		float localPivotMatB[4][4];
		unsigned int data[16];
	};

	//MAM|CgWCg\
	struct MAM_POINT_JOINT_DATA_1_0_0_0
	{
		float pivotSpring;
		float pivotDamper;
		unsigned int reserve[14];
	};

	//MAMqWWCg\
	struct MAM_HINGE_JOINT_DATA_1_0_0_0
	{
		float axis[4];
		float lowerLimit;
		float upperLimit;
		float limitSpring;
		float limitDamper;
		unsigned int reserve[8];
	};

	//MAM{[WCg\
	struct MAM_BALL_JOINT_DATA_1_0_0_0
	{
		float twistAxis[4];
		float swingAxis[4];
		float twistLimit;
		float swingLimit1;
		float swingLimit2;
		float pivotSpring;
		float pivotDamper;
		float limitSpring;
		float limitDamper;
		unsigned int reserve;
	};

	//MAMCt[\
	struct MAM_MAINFRAME_1_0_0_0
	{
		float scaling[4];
		float rotation[4];
		float translation[4];

		unsigned int coordinateSystem;

		unsigned int colliderNum;
		unsigned int sensorNum;

		unsigned int reserve;

		float receiveMotionMatrix[4][4];
	};

	//MAMm[h\
	struct MAM_NODE_1_0_0_0
	{
		wchar_t name[Mix::Tool::Win32::Graphics::MAX_NAME_SIZE];

		float geometricS[4];
		float geometricR[4];
		float geometricT[4];

		float localS[4];
		float localR[4];
		float localT[4];

		int meshIndex;

		unsigned int colliderNum;
		unsigned int sensorNum;
		unsigned int jointNum;

		int parent;
		int childCount;
	};

}}}}
