#pragma once

#include <list>
#include <vector>
#include <map>
#include <string>

#include "Mix/Tool/Win32/Core/Object.h"
#include "Mix/Tool/Win32/Core/File/InputStream.h"
#include "Mix/Tool/Win32/Core/File/TemporaryStream.h"
#include "Mix/Tool/Win32/Core/Graphics/Material.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class Object;
	class DeviceObject;

	class VertexLayout;
	class VertexShader;
	class PixelShader;
	class VertexBuffer;
	class IndexBuffer;
	class Texture;
	class FileTexture;
	class TargetTexture;
	class CubeTexture;
	class SwapChain;

	class Scene;
	class Camera;
	class Material;
	class MaterialShader;
	class MaterialModel;
	class ObjectModel;
	class MapModel;

	class Manager : public Mix::Tool::Win32::Object
	{
	public:
		//_[Xe[g^Cv
		enum RENDERSTATE_TYPE
		{
			RENDERSTATE_FILLMODE			= 0,	//tB[h
			RENDERSTATE_CULLMODE			= 1,	//JO[h
			RENDERSTATE_SCISSORTESTENABLE	= 2,	//VU[eXg
			RENDERSTATE_ZENABLE				= 3,	//Zobt@
			RENDERSTATE_ZWRITEENABLE		= 4,	//Zobt@̏
			RENDERSTATE_ALPHABLENDENABLE	= 5,	//At@uh
			RENDERSTATE_SRCBLEND			= 6,	//uh[h
			RENDERSTATE_DESTBLEND			= 7,	//uh[h
			RENDERSTATE_BLENDOP				= 8,	//uhIy[V
			RENDERSTATE_COLORWRITE			= 9,	//J[̏

			RENDERSTATE_TYPE_MAX			= 10,	//_[Xe[gő吔
		};

		//Tv[Xe[g^Cv
		enum SAMPLERSTATE_TYPE
		{
			SAMPLERSTATE_MAGFILTER	= 0,	//gtB^[
			SAMPLERSTATE_MINFILTER	= 1,	//ktB^[
			SAMPLERSTATE_MIPFILTER	= 2,	//~bvtB^[
			SAMPLERSTATE_ADDRESSU	= 3,	//UW̃AhbVO[h
			SAMPLERSTATE_ADDRESSV	= 4,	//VW̃AhbVO[h
			SAMPLERSTATE_ADDRESSW	= 5,	//WW̃AhbVO[h
			SAMPLERSTATE_ANISOTROPY	= 6,	//ٕ

			SAMPLERSTATE_TYPE_MAX	= 7,	//Tv[Xe[gő吔
		};

	private:
		enum VALUE
		{
			MAX_FPS = 60,
		};

		//ANV^Cv
		enum ACTION_TYPE
		{
			ACTION_RENDER_SCENE				= 0,	//V[`
			ACTION_INVALIDATE_DEVICEOBJECT	= 1,	//foCXIuWFNg𖳌ɂ
			ACTION_VALIDATE_DEVICEOBJECT	= 2,	//foCXIuWFNgLɂ
			ACTION_CREATE_DEVICE			= 3,	//foCX쐬
		};

		//VF[_[vt@C񋓒萔
		enum SHADER_PROFILE
		{
			SHADER_PROFILE_VS_3 = 0,
			SHADER_PROFILE_PS_3 = 1,

			SHADER_PROFILE_VS_4 = 2,
			SHADER_PROFILE_PS_4 = 3,

			SHADER_PROFILE_VS_5 = 4,
			SHADER_PROFILE_PS_5 = 5,

			SHADER_PROFILE_MAX	= 6,
		};

		//}eAVF[_[̃Xe[^X
		enum MS_STATE_TYPE
		{
			MS_STATE_EDITING	= 0,	//ҏW
			MS_STATE_NEW		= 1,	//VK( ۑ\ )
			MS_STATE_EXIST		= 2,	//
		};

		//MEPel
		enum MEP_VALUE
		{
			MEP_MAGIC_NUMBER = 0x5F50454D,

			MEP_VERSION_OLD	= 0x01000000,
			MEP_VERSION		= 0x01010000,
		};

		//MEP}eA^Cv
		enum MEP_MTL_TYPE
		{
			MEP_MTL_COLOR		= 0,
			MEP_MTL_MASK		= 1,
			MEP_MTL_SHADOW		= 2,

			MEP_MTL_TYPE_MAX	= 3,
		};

		//MEPZ[u\
		struct MEP_SAVE_INFO
		{
			unsigned int shaderModel;
			unsigned int number;
			SHADER_PROFILE vsProf;
			SHADER_PROFILE psProf;
		};

		//MEPt@C\
		struct MEP_FILE_INFO
		{
			std::wstring path;
			SHADER_PROFILE vsProf;
			SHADER_PROFILE psProf;
		};

		//MEP_[^Cv񋓒萔(o[W 0x01010000)
		enum MEP_RENDERER_TYPE
		{
			MEP_RT_STANDARD	= 0,
		};

		//MEPt@Cwb_\(o[W 0x01010000)
		struct MEP_FILE_HEADER
		{
			unsigned int magicNumber;
			unsigned int version;
		};

		//MEPf[^wb_\(o[W 0x01010000)
		struct MEP_DATA_HEADER
		{
			unsigned int rendererType;
			unsigned int processFlags;
			unsigned int vertexShaderNum;
			unsigned int pixelShaderNum;
		};

		//MEPo[ebNXVF[_[wb_\
		struct MEP_VS_HEADER
		{
			unsigned int id;
			unsigned int buffSize[Manager::MEP_MTL_TYPE_MAX];
			unsigned int elementNum;
			unsigned int reserve;
		};

		//MEPsNZVF[_[wb_\
		struct MEP_PS_HEADER
		{
			unsigned int id;
			unsigned int buffSize[Manager::MEP_MTL_TYPE_MAX];
		};

		//GtFNgpbP[W̊gq
		static const wchar_t* MEP_EXT;

		//GtFNgpbP[W̃Z[ue[u
		static const Manager::MEP_SAVE_INFO MEP_SAVE_INFO_TABLE[3];
		static const unsigned int MEP_SAVE_INFO_COUNT;

		//D3Do[ebNXGg̃Z}eBbNe[u
		static const unsigned int D3D_VE_SEMANTIC_TABLE[MAXD3DDECLUSAGE];
		//D3Do[ebNXGg̃tH[}bge[u
		static const unsigned int D3D_VE_FORMAT_TABLE[MAXD3DDECLTYPE];
		//D3Do[ebNXGg̃TCYe[u
		static const unsigned int D3D_VE_FORMAT_SIZE_TABLE[MAXD3DDECLTYPE];

		//o[ebNXGg̃Z}eBNXe[u
		static const unsigned char VES_TABLE[Mix::Tool::Win32::Graphics::VERTEX_ELEMENT_SEMANTIC_MAX];
		//o[ebNXGg̃tH[}bge[u
		static const unsigned char VE_FORMAT_TABLE[Mix::Tool::Win32::Graphics::VERTEX_ELEMENT_FORMAT_MAX];
		//o[ebNXGg̃tH[}bg̃TCYe[u
		static const unsigned char VE_FORMAT_SIZE_TABLE[Mix::Tool::Win32::Graphics::VERTEX_ELEMENT_FORMAT_MAX];

		//CfbNXtH[}bge[u
		static const D3DFORMAT INDEX_FORMAT_TABLE[Mix::Tool::Win32::Graphics::INDEX_TYPE_MAX];
		//CfbNXXgChe[u
		static const unsigned int INDEX_STRIDE_TABLE[Mix::Tool::Win32::Graphics::INDEX_TYPE_MAX];

		//VF[_[vt@Ce[u
		static const char* SHADER_PROFILE_TABLE[Manager::SHADER_PROFILE_MAX];
		static const wchar_t* SHADER_PROFILE_TABLE_W[Manager::SHADER_PROFILE_MAX];
		static const unsigned int SHADER_PROFILE_NUMBER_TABLE[Manager::SHADER_PROFILE_MAX];

		//VF[_[f`e[u
		static LPCSTR SHADER_DEFMODEL_TABLE[Manager::SHADER_PROFILE_MAX];
		static LPCSTR SHADER_DEFONE;

		//eNX`gqe[u
		static const wchar_t* TEXTURE_EXT_TABLE[6];
		static const unsigned int TEXTURE_EXT_COUNT;

		//}EXIvV\
		struct MOUSE_OPTION
		{
			float scalingSensitivity;
			float rotationSensitivity;
			float translationSensitivity;
		};

		//eNX`IvV\
		struct TEXTURE_OPTION
		{
			std::wstring specular;
			std::wstring emissive;
			std::wstring bump;
		};

		//p[XyNeBuIvV\
		struct PERSPECTIVE_OPTION
		{
			float fovY;
			float nearZ;
			float farZ;
		};

		//_[Xe[g\
		struct RENDERSTATE
		{
			D3DRENDERSTATETYPE type;
			DWORD defValue;
			DWORD nowValue;
		};

		//Tv[Xe[g\
		struct SAMPLERSTATE
		{
			D3DSAMPLERSTATETYPE type;
			DWORD defValue;
			DWORD nowValue;
		};

		//^[QbgXe[g\
		struct TARGETSTATE
		{
			Mix::Tool::Win32::Graphics::Texture* pT0;
			Mix::Tool::Win32::Graphics::Texture* pT1;
			Mix::Tool::Win32::Graphics::Texture* pT2;
			Mix::Tool::Win32::Graphics::Texture* pT3;
		};

		//`Xe[g\
		struct DRAWSTATE
		{
			struct
			{
				IDirect3DVertexDeclaration9* pD3DVertexLayout;

				IDirect3DVertexShader9* pD3DVertexShader;
				IDirect3DPixelShader9* pD3DPixelShader;

				IDirect3DVertexBuffer9* pD3DVertexBuffer;
				unsigned int vertexStride;

				IDirect3DIndexBuffer9* pD3DIndexBuffer;

				IDirect3DBaseTexture9* pD3DTexture[Mix::Tool::Win32::Graphics::TEXTURE_STAGE_MAX];
			}current, next;
		};

		//VF[_[}N\
		struct SHADER_MACRO
		{
			std::string name;
			std::string def;

			SHADER_MACRO( const char* pName, const char* pDef )
			{
				name = ( pName != NULL )? pName : "";
				def = ( pDef != NULL )? pDef : "";
			}
		};

		//D3DX֐̒` : D3DXCompileShader
		typedef HRESULT ( WINAPI *D3DXCompileFromMemoryFunc )(
			LPCSTR pSrcData,
			SIZE_T SrcDataLen,
			LPCSTR pFileName,
			CONST D3D10_SHADER_MACRO *pDefines,
			LPD3D10INCLUDE pInclude,
			LPCSTR pFunctionName,
			LPCSTR pProfile,
			UINT Flags1,
			UINT Flags2,
			ID3DX11ThreadPump* pPump,
			ID3D10Blob** ppShader,
			ID3D10Blob** ppErrorMsgs,
			HRESULT* pHResult );

		//eNX`f[^\
		struct TEXTURE_DATA
		{
			int refCount;
			D3DSURFACE_DESC d3dDesc;
			IDirect3DTexture9* pD3DInterface;
		};

		//MSo[ebNXVF[_[\
		struct MS_VERTEX_SHADER
		{
			Manager::MS_STATE_TYPE state;

			unsigned int optFlags;

			Mix::Tool::Win32::Graphics::VertexLayout* pCommonVL;
			Mix::Tool::Win32::Graphics::VertexShader* pColorVS;
			Mix::Tool::Win32::Graphics::VertexShader* pMaskVS;
			Mix::Tool::Win32::Graphics::VertexShader* pSelectVS;

			MS_VERTEX_SHADER( Manager::MS_STATE_TYPE _state )
			{
				state = _state;

				optFlags = 0;

				pCommonVL = NULL;
				pColorVS = NULL;
				pMaskVS = NULL;
				pSelectVS = NULL;
			}
		};

		//MSsNZVF[_[\
		struct MS_PIXEL_SHADER
		{
			Manager::MS_STATE_TYPE state;

			Mix::Tool::Win32::Graphics::PixelShader* pColorPS;
			Mix::Tool::Win32::Graphics::PixelShader* pMaskPS;
			Mix::Tool::Win32::Graphics::PixelShader* pSelectPS;

			MS_PIXEL_SHADER( Manager::MS_STATE_TYPE _state )
			{
				state = _state;

				pColorPS = NULL;
				pMaskPS = NULL;
				pSelectPS = NULL;
			}
		};

		//MSP(MATERIAL)o[ebNXVF[_[[N\
		struct MEP_MTL_VS_WORK
		{
			std::vector<Mix::Tool::Win32::Graphics::VERTEX_ELEMENT> elements;
			std::vector<Manager::SHADER_MACRO> macros;
			std::vector<unsigned char> buff[Manager::MEP_MTL_TYPE_MAX];
		};

		//MSP(MATERIAL)sNZVF[_[[N\
		struct MEP_MTL_PS_WORK
		{
			std::vector<Manager::SHADER_MACRO> macros;
			std::vector<unsigned char> buff[Manager::MEP_MTL_TYPE_MAX];
		};

		typedef std::map<std::wstring, Mix::Tool::Win32::Graphics::FileTexture*> TextureMap;
		typedef std::map<unsigned int, Manager::MS_VERTEX_SHADER> MSVertexShaderMap;
		typedef std::map<unsigned int, Manager::MS_PIXEL_SHADER> MSPixelShaderMap;

	private:
		static Manager* g_pInstance;

		std::wstring m_RootDirectoryPath;

		HMODULE m_hShaderCompileModule;
		D3DXCompileFromMemoryFunc m_pShaderCompile;

		IDirect3D9* m_pD3D;
		IDirect3DDevice9* m_pD3DDevice;
		IDirect3DSurface9* m_pD3DBackBuffer;

		D3DPRESENT_PARAMETERS m_D3DDevicePresentParam;

		unsigned int m_SupportShaderModels;

		unsigned int m_MSPShaderModels;
		unsigned int m_MSPProcFlags;
		std::wstring m_MSPDirectoryName;
		std::wstring m_MSPName;

		Manager::MOUSE_OPTION m_MouseOption;
		Manager::TEXTURE_OPTION m_TextureOption;
		Manager::PERSPECTIVE_OPTION m_PerspectiveOption;

		D3DXMATRIX m_ProjectionMatrix;

		ID3DXFont* m_pD3DFont;

		Mix::Tool::Win32::Graphics::VertexLayout* m_pLineVL;
		Mix::Tool::Win32::Graphics::VertexShader* m_pLineVS;
		Mix::Tool::Win32::Graphics::PixelShader* m_pLinePS;

		Mix::Tool::Win32::Graphics::VertexLayout* m_pQuadVL;
		Mix::Tool::Win32::Graphics::VertexShader* m_pQuadVS;
		Mix::Tool::Win32::Graphics::PixelShader* m_pQuadPS;

		std::list<Mix::Tool::Win32::Graphics::DeviceObject*> m_DeviceObjectList;
		std::list<Mix::Tool::Win32::Graphics::Scene*> m_SceneList;
		std::list<Mix::Tool::Win32::Graphics::Material*> m_WaveMaterialList;

		Manager::MSVertexShaderMap m_MSVertexShaderMap;
		Manager::MSPixelShaderMap m_MSPixelShaderMap;

		Manager::TextureMap m_TextureMap;

		Manager::ACTION_TYPE m_ActionType;

		std::vector<D3DXMATRIX> m_TempMatList;

		Manager::RENDERSTATE m_RenderStateTable[Manager::RENDERSTATE_TYPE_MAX];
		Manager::SAMPLERSTATE m_SamplerStateTable[Mix::Tool::Win32::Graphics::TEXTURE_STAGE_MAX][Manager::SAMPLERSTATE_TYPE_MAX];
		Manager::TARGETSTATE m_TargetState;
		Manager::DRAWSTATE m_DrawState;

		float m_Fps;

	public:
		Manager( void );
		~Manager( void );

		static Manager* GetInstance( void );

	private:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// foCX
		////////////////////////////////////////////////////////////////////////////////////////////////////

		bool CreateDevice( HWND hWnd );
		void ReleaseDevice( void );

		void LostRenderState( void );
		void LostSamplerState( void );
		void ResetTargetState( void );

		void ResetDrawState( void );
		void FlushDrawState( void );

		void NotifyDeviceLost( void );
		void InvalidateDeviceObject( void );
		void ValidateDeviceObject( void );

		void AddDeviceObject( Mix::Tool::Win32::Graphics::DeviceObject* pDeviceObject );
		void RemoveDeviceObject( Mix::Tool::Win32::Graphics::DeviceObject* pDeviceObject );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// foCXReLXg
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void SetRenderState( Manager::RENDERSTATE_TYPE type, DWORD value );
		void SetSamplerState( unsigned int stage, Manager::SAMPLERSTATE_TYPE type, DWORD value );
		void SetRasterizerState( D3DFILLMODE fill, D3DCULL cull, bool bScissoring );
		void SetDepthState( bool bTest, bool bWrite );
		void SetBlendState( Mix::Tool::Win32::Graphics::BLEND_MODE blend, unsigned int colorMask = 0x0000000F );

		void SetScissorRect( const RECT& rect );
		void SetScissorRect( unsigned int width, unsigned int height );
		void SetScissorRect( unsigned int x, unsigned int y, unsigned int width, unsigned int height );

		void SetViewport( unsigned int width, unsigned int height );
		void SetViewport( unsigned int x, unsigned int y, unsigned int width, unsigned int height );
		void SetViewport( const D3DVIEWPORT9& vp );

		void SetTarget( Mix::Tool::Win32::Graphics::Texture* pT0,
						Mix::Tool::Win32::Graphics::Texture* pT1,
						Mix::Tool::Win32::Graphics::Texture* pT2,
						Mix::Tool::Win32::Graphics::Texture* pT3 );

		void Clear( bool clearTarget, bool clearDepth, const D3DXVECTOR4& clearColor );

		void SetVertexShaderConstant( unsigned int slot, const D3DXVECTOR3& v );
		void SetVertexShaderConstant( unsigned int slot, const D3DXVECTOR4& v );
		void SetVertexShaderConstant( unsigned int slot, const D3DXMATRIX& m );
		void SetVertexShaderConstant( unsigned int slot, const D3DXMATRIX* m, unsigned int count );
		void SetPixelShaderConstant( unsigned int slot, const D3DXVECTOR3& v );
		void SetPixelShaderConstant( unsigned int slot, const D3DXVECTOR4& v );
		void SetPixelShaderConstant( unsigned int slot, const D3DXMATRIX& m );

		void SetVertexLayout( Mix::Tool::Win32::Graphics::VertexLayout* pVertexLayout );
		void SetVertexShader( Mix::Tool::Win32::Graphics::VertexShader* pVertexShader );
		void SetPixelShader( Mix::Tool::Win32::Graphics::PixelShader* pPixelShader );
		void SetVertexBuffer( Mix::Tool::Win32::Graphics::VertexBuffer* pVertexBuffer );
		void SetIndexBuffer( Mix::Tool::Win32::Graphics::IndexBuffer* pIndexBuffer );
		void SetTexture( unsigned int stage, D3DTEXTUREFILTERTYPE filter, D3DTEXTUREADDRESS address, Mix::Tool::Win32::Graphics::Texture* pTexture );

		void DrawIndexedTL( unsigned int vertexStart, unsigned int vertexCount, unsigned int indexStart, unsigned int indexCount );
		void DrawLine( const D3DXMATRIX& mat, const std::vector<Mix::Tool::Win32::Graphics::LINE_VERTEX>& vertices );
		void DrawQuad( Mix::Tool::Win32::Graphics::Texture* pTexture );
		void DrawText( const D3DXVECTOR4& color, const POINT& pos, const wchar_t* pText );
		void DrawText( const D3DXVECTOR4& color, const RECT& rect, const wchar_t* pText );
		int GetTextHeight( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// IDirect3DC^[tF[X̍쐬
		////////////////////////////////////////////////////////////////////////////////////////////////////

		IDirect3DSwapChain9* D3D_CreateSwapChain( HWND hWnd, D3DPRESENT_PARAMETERS& d3dPresentParam, bool& bDevice );
		IDirect3DVertexDeclaration9* D3D_CreateVertexLayout( const D3DVERTEXELEMENT9* pElements );
		IDirect3DVertexShader9* D3D_CreateVertexShader( const void* pFunction );
		IDirect3DPixelShader9* D3D_CreatePixelShader( const void* pFunction );
		IDirect3DVertexBuffer9* D3D_CreateVertexBuffer( unsigned int size );
		IDirect3DIndexBuffer9* D3D_CreateIndexBuffer( D3DFORMAT format, unsigned int size );
		IDirect3DTexture9* D3D_CreateTexture( const wchar_t* pFileName, const void* pBuffer, unsigned int bufferSize, D3DSURFACE_DESC& d3dSurfaceDesc );
		IDirect3DTexture9* D3D_CreateTargetTexture( D3DSURFACE_DESC& desc );
		IDirect3DSurface9* D3D_CreateTargetSurface( D3DSURFACE_DESC& desc );
		IDirect3DCubeTexture9* D3D_CreateCubeTexture( const void* pBuffer, unsigned int bufferSize, D3DSURFACE_DESC& d3dSurfaceDesc );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// \[X̍쐬
		////////////////////////////////////////////////////////////////////////////////////////////////////

		Mix::Tool::Win32::Graphics::SwapChain* GetFirstSwapChain( void );
		Mix::Tool::Win32::Graphics::SwapChain* CreateSwapChain( HWND hWnd );

		Mix::Tool::Win32::Graphics::VertexLayout* CreateVertexLayout( const D3DVERTEXELEMENT9* pElements );
		Mix::Tool::Win32::Graphics::VertexShader* CreateVertexShader( const void* pBuffer, unsigned int bufferSize );
		Mix::Tool::Win32::Graphics::PixelShader* CreatePixelShader( const void* pBuffer, unsigned int bufferSize );

		Mix::Tool::Win32::Graphics::VertexBuffer* CreateVertexBuffer( unsigned int stride, unsigned int count, const void* initialData = NULL );
		Mix::Tool::Win32::Graphics::IndexBuffer* CreateIndexBuffer( Mix::Tool::Win32::Graphics::INDEX_TYPE type, unsigned int count, const void* initialData = NULL );

		Mix::Tool::Win32::Graphics::FileTexture* CreateTexture( const wchar_t* pFileName );
		Mix::Tool::Win32::Graphics::FileTexture* CreateTexture( const wchar_t* pFileName, const void* pBuffer, unsigned int bufferSize );
		void RemoveTexture( const wchar_t* pFileName );

		bool CheckTargetTextureFormat( D3DFORMAT d3dFormat );
		Mix::Tool::Win32::Graphics::TargetTexture* CreateTargetTexture( D3DFORMAT d3dFormat );
		Mix::Tool::Win32::Graphics::TargetTexture* CreateLockableTargetTexture( void );

		Mix::Tool::Win32::Graphics::CubeTexture* CreateCubeTexture( const wchar_t* pFileName );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// }eAGtFNgpbP[W
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void MEP_Release( void );

		int MEP_Load( const wchar_t* pFileName );

		bool MEP_CreateVertexShader(	unsigned int compileFlags,
										unsigned int& id,
										Mix::Tool::Win32::Graphics::VertexLayout** ppCommonVL,
										Mix::Tool::Win32::Graphics::VertexShader** ppColorVS,
										Mix::Tool::Win32::Graphics::VertexShader** ppMaskVS,
										Mix::Tool::Win32::Graphics::VertexShader** ppSelectVS );

		bool MEP_CreatePixelShader(		unsigned int compileFlags,
										unsigned int& id,
										Mix::Tool::Win32::Graphics::PixelShader** ppColorPS,
										Mix::Tool::Win32::Graphics::PixelShader** ppMaskPS,
										Mix::Tool::Win32::Graphics::PixelShader** ppSelectVS );

		void MEP_RegisterVertexShader( unsigned int id );
		void MEP_RegisterPixelShader( unsigned int id );

		bool MEP_CreateWorkFromFile(	const wchar_t* pFileName,
										std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
										std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_CreateWorkFromDirectory(	const wchar_t* pDirName,
											std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
											std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_WorkFromMTL(	const wchar_t* pFilePath, 
								std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
								std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_WorkFromMTL(	const wchar_t* pTypeName,
								const wchar_t* pFilePath,
								Mix::Tool::Win32::File::InputStream& input, 
								Mix::Tool::Win32::File::TemporaryStream& output,
								std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
								std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap,
								unsigned int* pVersion = NULL );

		bool MEP_WorkFromMTM(	const wchar_t* pFilePath, 
								std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
								std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_WorkFromMAM(	const wchar_t* pFilePath, 
								std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
								std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_WorkSkip(		const wchar_t* pTypeName,
								const wchar_t* pFilePath,
								unsigned int rwSize,
								Mix::Tool::Win32::File::InputStream& input,
								Mix::Tool::Win32::File::TemporaryStream& output );

		void MEP_UpdateShaderID(	Mix::Tool::Win32::Graphics::Material::MTL_INFO_HEADER_1_1_0_0& infoHeader,
									Mix::Tool::Win32::Graphics::Material::MTL_DATA_HEADER_1_1_0_0& dataHeader );

		bool MEP_CreateFileInfoList( std::vector<Manager::MEP_FILE_INFO>& fileInfoList );

		bool MEP_Compile(	Manager::SHADER_PROFILE vsProf,
							Manager::SHADER_PROFILE psProf,
							std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
							std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool MEP_Save(	const wchar_t* pFilePath, 
						std::map<unsigned int, Manager::MEP_MTL_VS_WORK>& vsMap,
						std::map<unsigned int, Manager::MEP_MTL_PS_WORK>& psMap );

		bool CompileShader( Manager::SHADER_PROFILE profile,
							const Manager::SHADER_MACRO* pDefs,
							Manager::MEP_MTL_TYPE type,
							std::vector<unsigned char>& buffer );

		bool CompileShader( const char* pName,
							Manager::SHADER_PROFILE profile,
							const Manager::SHADER_MACRO* pDefs,
							const char* pSrc,
							unsigned int srcSize,
							const char* pEntryFunction,
							std::vector<unsigned char>& buffer );

		void CreateCompileMacroList( unsigned int compileFlags, bool bEngine, std::vector<Manager::SHADER_MACRO>& macroList );

		static void CreateVertexElementList(	unsigned int compileFlags, std::vector<D3DVERTEXELEMENT9>& elementList );
		static void ConvertVertexElementList(	const std::vector<D3DVERTEXELEMENT9>& srcList,
												std::vector<Mix::Tool::Win32::Graphics::VERTEX_ELEMENT>& dstList );

		static void PushVertexElement( std::vector<D3DVERTEXELEMENT9>& elementList, BYTE type, BYTE usage );
		static void CloseVertexElement( std::vector<D3DVERTEXELEMENT9>& elementList );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// V[
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void AddScene( Mix::Tool::Win32::Graphics::Scene* pScene );
		void RemoveScene( Mix::Tool::Win32::Graphics::Scene* pScene );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// EH[^[}eA( gAj[V̍XVp )
		////////////////////////////////////////////////////////////////////////////////////////////////////

		void AddWaveMaterial( Mix::Tool::Win32::Graphics::Material* pMaterial );
		void RemoveWaveMaterial( Mix::Tool::Win32::Graphics::Material* pMaterial );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// }EX̑( x𔽉flԂ܂ )
		////////////////////////////////////////////////////////////////////////////////////////////////////

		float GetDistation( int d );
		float GetScaling( const D3DXVECTOR2& basePos, const D3DXVECTOR2& pos );
		D3DXVECTOR3 GetRotation( int h, int v );
		D3DXVECTOR3 GetTranslation( int h, int v );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// fBt[YeNX`̖OeeNX`̖Oւ̕ϊ
		////////////////////////////////////////////////////////////////////////////////////////////////////

		bool GetSpecularTextureFileName( const wchar_t* pDiffuseTextureFileName, std::wstring& output );
		bool GetEmissiveTextureFileName( const wchar_t* pDiffuseTextureFileName, std::wstring& output );
		bool GetBumpTextureFileName( const wchar_t* pDiffuseTextureFileName, std::wstring& output );
		static bool FindTextureFile( const wchar_t* pDiffuseTextureFileName, const wchar_t* pFormat, std::wstring& output );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// ̑
		////////////////////////////////////////////////////////////////////////////////////////////////////

		static unsigned int ToColorUI( const D3DXVECTOR4& src );

	public:
		bool Initialize( void );

		unsigned int GetSupportShaderModels( void ) const;

		const wchar_t* GetRootDirectoryPath( void ) const;
		void SetRootDirectoryPath( const wchar_t* pDirectoryName );

		bool MEP_Load( unsigned int models, unsigned int procFlags, const wchar_t* pDirectoryName, const wchar_t* pName );
		bool MEP_Save( void );
		bool MEP_Compile( void );
		bool MEP_Compile( const std::vector<std::wstring>& subDirList );
		unsigned int MEP_GetShaderModels( void ) const;
		unsigned int MEP_GetProcessFlags( void ) const;

		float GetMouseScalingSensitivity( void ) const;
		void SetMouseScalingSensitivity( float ratio );
		float GetMouseRotationSensitivity( void ) const;
		void SetMouseRotationSensitivity( float ratio );
		float GetMouseTranslationSensitivity( void ) const;
		void SetMouseTranslationSensitivity( float ratio );

		const wchar_t* GetSpecularTextureFindFormat( void ) const;
		void SetSpecularTextureFindFormat( const wchar_t* pFormat );
		const wchar_t* GetEmissiveTextureFindFormat( void ) const;
		void SetEmissiveTextureFindFormat( const wchar_t* pFormat );
		const wchar_t* GetBumpTextureFindFormat( void ) const;
		void SetBumpTextureFindFormat( const wchar_t* pFormat );

		float GetPerspectiveFovY( void ) const;
		void SetPerspectiveFovY( float fovY );
		float GetPerspectiveNearZ( void ) const;
		void SetPerspectiveNearZ( float nearZ );
		float GetPerspectiveFarZ( void ) const;
		void SetPerspectiveFarZ( float farZ );
		void UpdateProjectionMatrix( void );
		const D3DXMATRIX& GetProjectionMatrix( void ) const;

		void Update( int baseFps, float fps, float mag );
		void Refresh( void );
		void Draw( void );

		float GetFramesPerSec( void ) const;

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Object;
		friend class DeviceObject;
		friend class SwapChain;
		friend class VertexLayout;
		friend class VertexShader;
		friend class PixelShader;
		friend class VertexBuffer;
		friend class IndexBuffer;
		friend class FileTexture;
		friend class TargetTextureD;
		friend class TargetTextureL;
		friend class CubeTexture;
		friend class OptimizeMesh;
		friend class MaterialShader;
		friend class Material;
		friend class Scene;
		friend class Camera;
		friend class DrawObject;
		friend class ObjectModel;
		friend class MapModel;
	};

}}}}
