#include "Mix/Tool/Win32/Core/Graphics/MapMesh.h"
#include "Mix/Tool/Win32/Core/Graphics/VertexBuffer.h"
#include "Mix/Tool/Win32/Core/Graphics/IndexBuffer.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

MapMesh::MapMesh( Mix::Tool::Win32::Graphics::DrawObject* pDrawObject ) : OptimizeMesh( pDrawObject, NULL )
{
}

MapMesh::~MapMesh( void )
{
}

void MapMesh::ApplyPivotScaleToPolygon( const D3DXVECTOR3& pivotScale )
{
	return;
	MIX_ASSERT( m_PolygonList.size() > 0 );

	Mix::Tool::Win32::Graphics::POLYGON* pPolygon = &( m_PolygonList[0] );
	Mix::Tool::Win32::Graphics::POLYGON* pPolygonEnd = pPolygon + m_PolygonList.size();

	D3DXMATRIX scaleMat;

	::D3DXMatrixScaling( &scaleMat, pivotScale.x, pivotScale.y, pivotScale.z );

	while( pPolygon != pPolygonEnd )
	{
		Mix::Tool::Win32::Graphics::VERTEX* pVertex = &( pPolygon->vertices[0] );
		Mix::Tool::Win32::Graphics::VERTEX* pVertexEnd = pVertex + pPolygon->vertices.size();

		D3DXVECTOR4 temp;

		while( pVertex != pVertexEnd )
		{
			::D3DXVec3Transform( &temp, &( pVertex->pos ), &scaleMat );

			pVertex->pos.x = temp.x;
			pVertex->pos.y = temp.y;
			pVertex->pos.z = temp.z;

			pVertex++;
		}

		pPolygon++;
	}
}

bool MapMesh::Write( Mix::Tool::Win32::File::OutputStream& output )
{
	if( ( m_SubsetList.size() == 0 ) ||
		( m_pVertexBuffer == NULL ) ||
		( m_pIndexBuffer == NULL ) )
	{
		return false;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// wb_
	////////////////////////////////////////////////////////////////////////////////////////////////////

	{
		MapMesh::MESH_DESC desc;

		desc.materialNum = m_SubsetList.size();
		desc.vertexStride = m_pVertexBuffer->GetStride();
		desc.vertexNum = m_pVertexBuffer->GetCount();
		desc.indexStride = m_pIndexBuffer->GetStride();
		desc.indexNum = m_pIndexBuffer->GetCount();
		desc.reserve = 0;

		if( output.Write( &desc, sizeof( desc ) ) == false )
		{
			return false;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// }eA
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( WriteSimpleMaterial( output ) == false )
	{
		return false;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// o[ebNXobt@
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( WriteVertexBuffer( output ) == false )
	{
		return false;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// CfbNXobt@
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( WriteIndexBuffer( output ) == false )
	{
		return false;
	}

	return true;
}

Mix::Tool::Win32::Object::TYPE MapMesh::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__MAP_MESH;
}

}}}}
