#pragma once

#include "Mix/Tool/Win32/Core/File/OutputStream.h"
#include "Mix/Tool/Win32/Core/Graphics/OptimizeMesh.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class DrawObject;

	class MapMesh : public Mix::Tool::Win32::Graphics::OptimizeMesh
	{
	private:
		//MESHwb_\
		struct MESH_DESC
		{
			unsigned int materialNum;
			unsigned int vertexStride;
			unsigned int vertexNum;
			unsigned int indexStride;
			unsigned int indexNum;
			unsigned int reserve;
		};

	public:
		MapMesh( Mix::Tool::Win32::Graphics::DrawObject* pDrawObject );
		virtual ~MapMesh( void );

	public:
		void ApplyPivotScaleToPolygon( const D3DXVECTOR3& pivotScale );
		bool Write( Mix::Tool::Win32::File::OutputStream& output );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
