#include "Mix/Tool/Win32/Core/Graphics/MapViewMesh.h"
#include "Mix/Tool/Win32/Core/Graphics/MapMesh.h"

#include <algorithm>

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

MapViewMesh::MapViewMesh( void ) :
m_PolygonCount( 0 ),
m_VertexCount( 0 ),
m_IndexCount( 0 )
{
}

MapViewMesh::~MapViewMesh( void )
{
}

void MapViewMesh::SetPolygonCount( unsigned int count )
{
	m_PolygonCount = count;
	m_VertexCount = count * 3;
	m_IndexCount = count * 3;
}

void MapViewMesh::AddMaterialSlotIndex( unsigned int index )
{
	if( std::find( m_SubsetList.begin(), m_SubsetList.end(), index ) == m_SubsetList.end() )
	{
		m_SubsetList.push_back( index );
	}
}

void MapViewMesh::AddEditMeshPtr( Mix::Tool::Win32::Graphics::MapMesh* pMesh )
{
	m_EditMeshList.push_back( pMesh );
}

void MapViewMesh::SortMaterialSlotIndex( void )
{
	std::sort( m_SubsetList.begin(), m_SubsetList.end() );
}

void MapViewMesh::SetKey( unsigned int key )
{
	Mesh::SetKey( key );

	for( MapViewMesh::EditMeshList::iterator it = m_EditMeshList.begin(); it != m_EditMeshList.end(); ++it )
	{
		Mix::Tool::Win32::Graphics::MapMesh* pEditMesh = ( *it );
		pEditMesh->SetKey( key );
	}
}

void MapViewMesh::SetVisible( bool state )
{
	Mesh::SetVisible( state );

	for( MapViewMesh::EditMeshList::iterator it = m_EditMeshList.begin(); it != m_EditMeshList.end(); ++it )
	{
		Mix::Tool::Win32::Graphics::MapMesh* pEditMesh = ( *it );
		pEditMesh->SetVisible( state );
	}
}

unsigned int MapViewMesh::GetPolygonCount( void ) const
{
	return m_PolygonCount;
}

unsigned int MapViewMesh::GetVertexCount( void ) const
{
	return m_VertexCount;
}

unsigned int MapViewMesh::GetIndexCount( void ) const
{
	return m_IndexCount;
}

unsigned int MapViewMesh::GetSubsetCount( void ) const
{
	return m_SubsetList.size();
}

unsigned int MapViewMesh::GetMaterialSlotIndexBySubsetIndex( unsigned int subsetIndex ) const
{
	if( m_SubsetList.size() <= subsetIndex )
	{
		return 0;
	}

	return m_SubsetList[subsetIndex];
}

}}}}
