#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Graphics/Mesh.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class MapMesh;

	//! @class MapViewMesh
	//! @brief }bvr[bVNX
	//! @note
	//! fGfB^[̃AEgCi[̕\p
	//!  bV͎Ă܂
	class MapViewMesh : public Mix::Tool::Win32::Graphics::Mesh
	{
	private:
		typedef std::vector<unsigned int> SubsetList;
		typedef std::vector<Mix::Tool::Win32::Graphics::MapMesh*> EditMeshList;

	private:
		unsigned int m_PolygonCount;
		unsigned int m_VertexCount;
		unsigned int m_IndexCount;
		MapViewMesh::SubsetList m_SubsetList;
		MapViewMesh::EditMeshList m_EditMeshList;

	public:
		MapViewMesh( void );
		virtual ~MapViewMesh( void );

	private:
		void SetPolygonCount( unsigned int count );

		void AddMaterialSlotIndex( unsigned int index );
		void SortMaterialSlotIndex( void );

		void AddEditMeshPtr( Mix::Tool::Win32::Graphics::MapMesh* pMesh );

	public:
		virtual void SetKey( unsigned int key );
		virtual void SetVisible( bool state );

		virtual unsigned int GetPolygonCount( void ) const;
		virtual unsigned int GetVertexCount( void ) const;
		virtual unsigned int GetIndexCount( void ) const;
		virtual unsigned int GetSubsetCount( void ) const;
		virtual unsigned int GetMaterialSlotIndexBySubsetIndex( unsigned int subsetIndex ) const;

		friend class OctreeModel;
		friend class MapModel;
	};

}}}}
