#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class VertexLayout;
	class VertexShader;
	class PixelShader;

	class MaterialShader : public Mix::Tool::Win32::Object
	{
	private:
		unsigned int m_VertexShaderID[Mix::Tool::Win32::Graphics::VERTEX_TYPE_MAX];
		unsigned int m_PixelShaderID;

		Mix::Tool::Win32::Graphics::VertexLayout* m_pVertexLayout[Mix::Tool::Win32::Graphics::VERTEX_TYPE_MAX];
		Mix::Tool::Win32::Graphics::VertexShader* m_pVertexShader[Mix::Tool::Win32::Graphics::VERTEX_TYPE_MAX][Mix::Tool::Win32::Graphics::MAPPING_TYPE_MAX];
		Mix::Tool::Win32::Graphics::PixelShader* m_pPixelShader[Mix::Tool::Win32::Graphics::MAPPING_TYPE_MAX];

		Mix::Tool::Win32::Graphics::VertexShader* m_pSelectVS[Mix::Tool::Win32::Graphics::VERTEX_TYPE_MAX];
		Mix::Tool::Win32::Graphics::PixelShader* m_pSelectPS;

	public:
		MaterialShader( void );
		~MaterialShader( void );

		void Compile( unsigned int flags );
		void Register( void );

		unsigned int GetVertexShaderID( Mix::Tool::Win32::Graphics::VERTEX_TYPE type ) const;
		unsigned int GetPixelShaderID( void ) const;

		Mix::Tool::Win32::Graphics::VertexLayout* GetVertexLayoutPtr( Mix::Tool::Win32::Graphics::VERTEX_TYPE vertexType ) const;
		Mix::Tool::Win32::Graphics::VertexShader* GetVertexShaderPtr( Mix::Tool::Win32::Graphics::VERTEX_TYPE vertexType, Mix::Tool::Win32::Graphics::MAPPING_TYPE mappingType ) const;
		Mix::Tool::Win32::Graphics::PixelShader* GetPixelShaderPtr( Mix::Tool::Win32::Graphics::MAPPING_TYPE mappingType ) const;

		Mix::Tool::Win32::Graphics::VertexShader* GetSelectVertexShaderPtr( Mix::Tool::Win32::Graphics::VERTEX_TYPE vertexType ) const;
		Mix::Tool::Win32::Graphics::PixelShader* GetSelectPixelShaderPtr( void ) const;

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
