#pragma once

#include <string>
#include <map>
#include <vector>

#include "Mix/Tool/Win32/Core/Object.h"
#include "Mix/Tool/Win32/Core/File/OutputStream.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class DrawObject;
	class Material;

	class MaterialSlot : public Mix::Tool::Win32::Object
	{
	private:
		static const wchar_t* ADD_NAME;
		static const unsigned int MAX_ADD_NUMBER;

	private:
		Mix::Tool::Win32::Graphics::DrawObject* m_pDrawObject;
		unsigned int m_Index;
		std::wstring m_DefaultName;
		std::wstring m_Name;
		std::vector<Mix::Tool::Win32::Graphics::Material*> m_List;
		Mix::Tool::Win32::Graphics::Material* m_pDefaultMaterial;
		Mix::Tool::Win32::Graphics::Material* m_pActiveMaterial;
		unsigned int m_Flags;

	private:
		MaterialSlot( Mix::Tool::Win32::Graphics::DrawObject* pDrawObject, unsigned int index, const wchar_t* pName );
		virtual ~MaterialSlot( void );

		void Destroy( void );

		std::vector<Mix::Tool::Win32::Graphics::Material*>::const_iterator GetIterator( const wchar_t* pName ) const;

		bool CreateMaterialName( Mix::Tool::Win32::Graphics::Material* pMaterial, const wchar_t* pRequestName, std::wstring& name );
		void SetActiveMaterial( Mix::Tool::Win32::Graphics::Material* pMaterial );

		bool WriteDefault( const wchar_t* pFilePath, Mix::Tool::Win32::File::OutputStream& output );
		bool SaveFile( void );

	public:
		const wchar_t* GetDefaultName( void ) const;

		void SetName( const wchar_t* pName );
		const wchar_t* GetName( void ) const;

		Mix::Tool::Win32::Graphics::Material* Add( void );
		void Remove( const wchar_t* pName );
		Mix::Tool::Win32::Graphics::Material* GetDefault( void ) const;
		Mix::Tool::Win32::Graphics::Material* GetActive( void ) const;
		Mix::Tool::Win32::Graphics::Material* GetByIndex( unsigned int index ) const;
		Mix::Tool::Win32::Graphics::Material* GetByName( const wchar_t* pName ) const;
		unsigned int GetCount( void ) const;

		void Update( Mix::Tool::Win32::Graphics::Material* pMaterial, bool bNotifyDrawObject );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class DrawObject;
		friend class Material;
	};

}}}}
