#include "Mix/Tool/Win32/Core/Graphics/Mesh.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

Mesh::Mesh( void ) :
m_Key( 0 ),
m_KeyColor( 0.0f, 0.0f, 0.0f, 0.0f ),
m_bVisible( true )
{
}

Mesh::~Mesh( void )
{
}

unsigned int Mesh::GetKey( void ) const
{
	return m_Key;
}

void Mesh::SetKey( unsigned int key )
{
	m_Key = key;

	m_KeyColor.x = static_cast<float>( ( m_Key       ) & 0x000000FF ) / 255.0f;
	m_KeyColor.y = static_cast<float>( ( m_Key >>  8 ) & 0x000000FF ) / 255.0f;
	m_KeyColor.z = static_cast<float>( ( m_Key >> 16 ) & 0x000000FF ) / 255.0f;
	m_KeyColor.w = 0.0f;
}

const D3DXVECTOR4& Mesh::GetKeyColor( void ) const
{
	return m_KeyColor;
}

bool Mesh::GetVisible( void ) const
{
	return m_bVisible;
}

void Mesh::SetVisible( bool state )
{
	m_bVisible = state;
}

}}}}
