#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class Mesh : public Mix::Tool::Win32::Object
	{
	private:
		unsigned int m_Key;
		D3DXVECTOR4 m_KeyColor;

		bool m_bVisible;

	public:
		Mesh( void );
		virtual ~Mesh( void );

		unsigned int GetKey( void ) const;
		virtual void SetKey( unsigned int key );

		const D3DXVECTOR4& GetKeyColor( void ) const;

		bool GetVisible( void ) const;
		virtual void SetVisible( bool state );

		virtual void OnRefresh( void ) {}

		virtual unsigned int GetPolygonCount( void ) const = 0;
		virtual unsigned int GetVertexCount( void ) const = 0;
		virtual unsigned int GetIndexCount( void ) const = 0;
		virtual unsigned int GetSubsetCount( void ) const = 0;
		virtual unsigned int GetMaterialSlotIndexBySubsetIndex( unsigned int subsetIndex ) const = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::GRAPHICS__MESH, Mix::Tool::Win32::Object )
	};

}}}}
