#pragma once

#include <string>
#include "Mix/Tool/Win32/Core/Graphics/DrawObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class Node;

	class Model : public Mix::Tool::Win32::Graphics::DrawObject
	{
	public:
		//C|[gIvV񋓒萔
		enum IMPORT_OPTION_TYPE
		{
			IO_DEFAULT				= 0,	//ftHg

			IO_FBX_MAYA				= 1,	//FBX : MAYA( RPre ̂ݑΉ )
			IO_FBX_3D_STUDIO_MAX	= 2,	//FBX : 3D Studio Max( WIgbNsgp@ )
		};

	private:
		std::wstring m_SaveFilePath;

	public:
		Model( void );
		virtual ~Model( void );

	public:
		void SetModelFilePath( const wchar_t* pFilePath );
		const wchar_t* GetModelFilePath( void ) const;

		bool IsAvailableSaveModel( void ) const;

	public:
		virtual const wchar_t* GetName( void ) const = 0;
		virtual Mix::Tool::Win32::Graphics::Node* GetRootNode( void ) = 0;
		virtual void SelectedMeshByKey( unsigned int key ) = 0;
		virtual void SelectedNode( Mix::Tool::Win32::Graphics::Node* pNode ) = 0;
		virtual bool SaveModel( void ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::GRAPHICS__MODEL, Mix::Tool::Win32::Graphics::DrawObject )
	};

}}}}
