#pragma once

#include "Mix/Tool/Win32/Core/File/OutputStream.h"
#include "Mix/Tool/Win32/Core/Graphics/OptimizeMesh.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class ObjectMesh : public Mix::Tool::Win32::Graphics::OptimizeMesh
	{
	private:
		enum INTERNAL_VALUE
		{
			JACOBI_MAX_LOOP = 100,	//Jacobi@̍ő僋[v
		};

		//r[{[\
		struct VIEW_VOLUME
		{
			D3DXVECTOR3 pos;
			D3DXVECTOR3 vec;
		};

		//MESHwb_\
		struct MESH_DESC
		{
			unsigned int boneNum;
			unsigned int boneMatNum;
			unsigned int viewVolumeNum;
			unsigned int materialNum;
			unsigned int vertexStride;
			unsigned int vertexNum;
			unsigned int indexStride;
			unsigned int indexNum;
		};

		//MESH{[\
		struct MESH_BONE
		{
			wchar_t linkNodeName[Mix::Tool::Win32::Graphics::MAX_NAME_SIZE];
			float offsetMat[4][4];
		};

		//MESHr[{[\
		struct MESH_VIEW_VOLUME
		{
			float pos[3];
			float vec[3];
		};

	private:
		std::vector<OptimizeMesh::BONE> m_BoneList;
		std::vector<D3DXMATRIX> m_BoneMatList;
		std::vector<unsigned int> m_BoneMatTable;

		std::vector<ObjectMesh::VIEW_VOLUME> m_LocalViewVolumeList;
		Mix::Tool::Win32::Geometry::SPHERE m_ViewVolume;

	public:
		ObjectMesh( Mix::Tool::Win32::Graphics::DrawObject* pDrawObject, Mix::Tool::Win32::Graphics::Node* pLinkNode );
		virtual ~ObjectMesh( void );

	public:
		const wchar_t* GetLinkNodeName( void ) const;
//		void Update( const D3DXMATRIX& worldMat );
		const Mix::Tool::Win32::Geometry::SPHERE& GetViewVolume( void ) const;
		bool Write( Mix::Tool::Win32::File::OutputStream& output );

	public:
		virtual bool GetBoneAvaliable( void ) const;
		virtual unsigned int AddBone( const char* pName, const D3DXMATRIX& offsetMat );
		virtual unsigned int AddBone( const wchar_t* pName, const D3DXMATRIX& offsetMat );
		virtual unsigned int GetBoneCount( void ) const;
		virtual const D3DXMATRIX* GetBoneMatList( void ) const;
		virtual const OptimizeMesh::BONE* GetBoneByIndex( unsigned int index ) const;
		virtual const OptimizeMesh::BONE* GetBoneByName( const wchar_t* pName ) const;

	protected:
		virtual bool OnBeforeBuild( OptimizeMesh::BUILD_CONFIG& cfg );
		virtual bool OnAfterBuild( OptimizeMesh::BUILD_CONFIG& cfg, const std::vector<OptimizeMesh::O_MATERIAL>& oMaterialList );
		virtual void OnRefresh( void );

	private:
		static ObjectMesh::VIEW_VOLUME ComputeViewVolume( const std::vector<D3DXVECTOR3>& vertices );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
