#pragma once

#include <string>
#include <list>
#include <vector>
#include <map>

#include "Mix/Tool/Win32/Core/Graphics/FBX.h"
#include "Mix/Tool/Win32/Core/Graphics/Model.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class BlankMesh;
	class Material;
	class MapMesh;
	class MapViewMesh;
	class Node;
	class MapCollision;

	//! @class OctreeModel
	//! @brief W؃fNX
	class OctreeModel : public Mix::Tool::Win32::Graphics::Model
	{
	public:
		//! @struct IMPORT_CONFIG
		//! @brief C|[gݒ\
		struct IMPORT_CONFIG
		{
			const wchar_t* pFilePath;	//!< t@CpX

			Mix::Tool::Win32::Graphics::Model::IMPORT_OPTION_TYPE opt;	//!< IvV

			float scaling;				//!< XP[
			D3DXVECTOR3 rotation;		//!< ]
			D3DXVECTOR3 translation;	//!< ړ

			D3DXVECTOR3 cellSize;		//!< iqTCY
			float cellError;			//!< iqTCY̌덷̋e͈

			bool bSmooting;				//!< X[WOLɂꍇ true
			float smootingAngle;		//!< X[WOpx( DEG )

			Mix::Tool::Win32::Graphics::MESH_BUILD_TYPE meshBuildType;	//!< bṼrh^Cv

			//! @brief RXgN^
			IMPORT_CONFIG( void )
			{
				pFilePath = NULL;

				opt = Mix::Tool::Win32::Graphics::Model::IO_FBX_MAYA;

				scaling = 1.0f;
				rotation = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
				translation = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );

				cellSize = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
				cellError = 0.001f;	//1.0f1mƂčlāAl1mmƂ

				bSmooting = false;
				smootingAngle = 45.0f;

				meshBuildType = Mix::Tool::Win32::Graphics::MESH_BUILD_OPTIMIZE;
			}
		};

	protected:
		typedef std::vector<Mix::Tool::Win32::Graphics::MapMesh*> MeshList;
		typedef std::vector<Mix::Tool::Win32::Graphics::MapViewMesh*> ViewMeshList;
		typedef std::vector<Mix::Tool::Win32::Graphics::Node*> NodeList;

		//؃m[h\
		struct OCT_NODE
		{
			//I[_[
			enum SPLITORDER
			{
				SO_YZ = 0,	//E
				SO_XZ = 1,	//㉺
				SO_XY = 2,	//O
			};

			//g̔ԍ
			int number;

			//em[h
			OCT_NODE* pParent;

			//qm[h
			std::vector<OCT_NODE*> childs;

			//bVԍ( ۑp )
			int meshNumber;

			//bV( t@C )
			Mix::Tool::Win32::Graphics::MapMesh* pMesh;

			//bV( GfBbg )
			OctreeModel::MeshList editMeshes;

			//m[h͂AABB
			Mix::Tool::Win32::Geometry::AABB aabb;

			//I[_[
			SPLITORDER splitOrder[3];
			int splitOrderCount;

			OCT_NODE( void )
			{
				pParent = NULL;
				number = -1;
				meshNumber = -1;
				pMesh = NULL;
				aabb.min = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
				aabb.max = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
				splitOrderCount = 0;
			}

			OCT_NODE( OCT_NODE* p0, const Mix::Tool::Win32::Geometry::AABB& p1 )
			{
				pParent = p0;
				if( pParent != NULL )
				{
					pParent->childs.push_back( this );
				}

				number = -1;
				meshNumber = -1;
				pMesh = NULL;
				aabb = p1;
				splitOrderCount = 0;
			}
		};

		typedef std::vector<OctreeModel::OCT_NODE*> OctNodeList;

	protected:
		//S
		std::wstring m_Title;
		bool m_bRenderingOnly;

		//O
		std::wstring m_Name;

		//ۑpbV
		OctreeModel::MeshList m_FileMeshList;
		OctreeModel::OctNodeList m_OctNodeList;

		//fGfB^[̃AEgCi[pbV
		OctreeModel::ViewMeshList m_ViewMeshList;
		OctreeModel::NodeList m_NodeList;

		//ffB^[̕`AIpbV
		OctreeModel::MeshList m_EditMeshList;
		unsigned int m_SelectedMeshKey;

	private:
		bool Optimize( const Mix::Tool::Win32::Graphics::OctreeModel::IMPORT_CONFIG& cfg, const OctreeModel::MeshList& meshes );
		void Draw( const D3DXMATRIX& worldMat, const OctreeModel::OCT_NODE* pNode, DrawObject::DRAW_EVENT_ARGS& args );
		void ReleaseModel( void );

		Mix::Tool::Win32::Graphics::OctreeModel::OCT_NODE* Octree_Create( const D3DXVECTOR3& cellSize, const float cellError, Mix::Tool::Win32::Graphics::OctreeModel::OCT_NODE* pParentNode, const Mix::Tool::Win32::Geometry::AABB& aabb );
		void Octree_InsertPolygon( unsigned viewMeshIndex, Mix::Tool::Win32::Graphics::OctreeModel::OCT_NODE* pNode, const Mix::Tool::Win32::Graphics::POLYGON& polygon );
		bool Octree_Optimize1( Mix::Tool::Win32::Graphics::OctreeModel::OCT_NODE* pNode );
		void Octree_Optimize2( Mix::Tool::Win32::Graphics::OctreeModel::OCT_NODE* pNode );
		void Octree_Finalize( std::vector<OctreeModel::OCT_NODE*>& nodeList, OctreeModel::OCT_NODE* pNode );
		void Octree_Release( OctreeModel::OCT_NODE* pNode );

		bool FBX_LoadNode( const OctreeModel::IMPORT_CONFIG& cfg, OctreeModel::MeshList& meshes, Mix::Tool::Win32::Graphics::FBX* pFbx, FbxNode* pFbxNode, Mix::Tool::Win32::Graphics::Node* pParentNode );

		static void ReleaseMeshes( OctreeModel::MeshList& meshes );

	public:
		//! @brief RXgN^
		OctreeModel( const wchar_t* pTitle, bool bRenderingOnly );
		//! @brief fXgN^
		virtual ~OctreeModel( void );

		//! @brief C|[g
		//! @param[in] cfg C|[gݒ\
		//! @param[in, out] pBlankMesh uNbVNX̃|C^( SẴbV )
		//! @return ꍇ true Ԃ܂
		bool Import( const OctreeModel::IMPORT_CONFIG& cfg, Mix::Tool::Win32::Graphics::BlankMesh* pBlankMesh = NULL );
		//! @brief C|[g̊
		//! @return ꍇ true Ԃ܂
		bool ImportFinalize( void );

	protected:
		//! @brief C|[gJnۂɌĂяo܂
		//! @param[in] cfg C|[gݒ
		virtual void OnPreImport( const OctreeModel::IMPORT_CONFIG& cfg ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const;
		//! @brief [gm[h擾܂
		//! @return [gm[h̃|C^Ԃ܂
		virtual Mix::Tool::Win32::Graphics::Node* GetRootNode( void );
		//! @brief I郁bṼL[ݒ肵܂
		//! @param[in] key I郁bṼL[
		//! @note bṼL[̓J擾邱Ƃł܂
		virtual void SelectedMeshByKey( unsigned int key );
		//! @brief Im[hݒ肵܂
		//! @param[in] pNode Im[h
		virtual void SelectedNode( Mix::Tool::Win32::Graphics::Node* pNode );
		//! @brief ۑ܂
		//! @return  false Ԃ܂
		virtual bool SaveModel( void );

	protected:
		virtual void OnDraw( DrawObject::DRAW_EVENT_ARGS& args );
		virtual void OnRefreshMesh( unsigned int materialSlotIndex );

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::GRAPHICS__OCTREE_MODEL, Mix::Tool::Win32::Graphics::Model );

		friend class Manager;
		friend class MapModel;
	};

}}}}

