#pragma once

#include <list>
#include <vector>

#include "Mix/Tool/Win32/Core/File/OutputStream.h"
#include "Mix/Tool/Win32/Core/Graphics/Mesh.h"
#include "Mix/Tool/Win32/Core/Graphics/ObjectModel.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class VertexBuffer;
	class IndexBuffer;
	class Node;

	class OptimizeMesh : public Mix::Tool::Win32::Graphics::Mesh
	{
	public:
		enum VALUE
		{
			BLOCK_MAX		= 256,		//őubN( [v )
			BLOCK_BONE_MAX	= 20,		//1̕`Ŏgpł{[̐( ŜŎgpł{[ł͂ȂƂɒӁI )
		};

		//rhRtBO
		struct BUILD_CONFIG
		{
			Mix::Tool::Win32::Graphics::MESH_BUILD_TYPE type;	//rh^Cv
			bool bSmooting;										//X[WOs
			float smootingAngle;								//X[WOpx( COS )
			void* pUserPtr;										//[U[|C^
		};

		//{[\
		struct BONE
		{
			std::wstring name; //O
			Mix::Tool::Win32::Graphics::Node* pLinkNode;	//NĂm[h̃|C^
			D3DXMATRIX offsetMat; //{[Ăꍇ́AItZbgsBłȂꍇ Pʍs
			D3DXMATRIX worldMat; //[hs( ItZbgs * m[hs )
		};

		//_\
		struct VERTEX
		{
			D3DXVECTOR3 pos;
			D3DXVECTOR4 color;
			D3DXVECTOR3 normal;
			D3DXVECTOR3 tangent;
			D3DXVECTOR3 binormal;
			D3DXVECTOR2 tex;
			unsigned char indices[Mix::Tool::Win32::Graphics::MAX_VERTEX_WEIGHT];
			float weights[Mix::Tool::Win32::Graphics::MAX_VERTEX_WEIGHT];
		};

		//`̃\[g\
		struct DRAW_SORT_INFO
		{
			int boneIndex;		//e󂯂{[̔ԍ( {[ĂȂꍇ -1 )
			D3DXVECTOR3 pos;	//\[gp̍W
		};

		//`\
		struct DRAW
		{
			unsigned int boneOffset;				//`Ɏgp{[s񃊃Xg̊Jnʒu
			unsigned int boneCount;					//`Ɏgp{[̐
			unsigned int vertexStart;				//`Ɏgp钸_̃Xg̊Jnʒu
			unsigned int vertexCount;				//`Ɏgp钸_̐
			unsigned int indexStart;				//`ɎgpCfbNX̃Xg̊Jnʒu
			unsigned int indexCount;				//`ɎgpCfbNX̐
			OptimizeMesh::DRAW_SORT_INFO sortInfo;	//`̃\[g( p )
		};

		//TuZbg\
		struct SUBSET
		{
			unsigned int materialIndex;					//}eACfbNX

			OptimizeMesh::DRAW draw;					//ꊇł̕`
			std::vector<OptimizeMesh::DRAW> drawList;	//|SPʂł̕`惊Xg

			bool operator()( const OptimizeMesh::SUBSET& l, const OptimizeMesh::SUBSET& r )
			{
				return ( l.materialIndex < r.materialIndex );
			}
		};

	protected:
		//œK : el
		enum O_VALUE
		{
			O_BONE_POLYGON_KEY_MAX = 12,	//{[|S̃L[ő吔
		};

		//œK : {[|S\
		struct O_BONE_POLYGON_INFO
		{
			unsigned int index;
			unsigned int keyCount;
			float key;

			bool operator()( const O_BONE_POLYGON_INFO& l, const O_BONE_POLYGON_INFO& r )
			{
				return ( l.key > r.key );
			}
		};

		//œK : {[|SL[\
		struct O_BONE_POLYGON_KEY
		{
			unsigned int index;
			float value;

			O_BONE_POLYGON_KEY( unsigned int _index, float _value )
			{
				index = _index;
				value = _value;
			}
		};

		//œK : {[|S\
		struct O_BONE_POLYGON
		{
			unsigned int keyCount;
			unsigned int keys[OptimizeMesh::O_BONE_POLYGON_KEY_MAX];

			const Mix::Tool::Win32::Graphics::POLYGON* pData;

			bool operator()( const O_BONE_POLYGON& l, const O_BONE_POLYGON& r )
			{
				unsigned int count = ( l.keyCount > r.keyCount )? l.keyCount : r.keyCount;
				unsigned int index = 0;

				while( index < OptimizeMesh::O_BONE_POLYGON_KEY_MAX )
				{
					unsigned int lk = l.keys[index];
					unsigned int rk = r.keys[index];

					if( lk < rk )
					{
						return true;
					}
					else if( lk > rk )
					{
						return false;
					}
					else if( lk == rk )
					{
						index++;
					}
				}

				return ( l.keyCount < r.keyCount );
			}
		};

		//œK : tFCX\
		struct O_FACE
		{
			unsigned int indexOffset;		//CfbNXz̃ItZbg
			unsigned int indices[3];		//_W̎QƃCfbNXz

			O_FACE( unsigned int i0, unsigned int i1, unsigned int i2 )
			{
				indices[0] = i0;
				indices[1] = i1;
				indices[2] = i2;

				indexOffset = 0;
			}
		};

		//œK : }eAubN\
		struct O_MATERIAL_BLOCK
		{
			unsigned int boneCount;
			unsigned int boneOffset;
			std::vector<unsigned int> boneRefTable;
			std::vector<unsigned int> boneList;

			std::vector<Mix::Tool::Win32::Graphics::VERTEX> vertexList;
			std::vector<unsigned int> vertexOptTable;

			std::vector<Mix::Tool::Win32::Graphics::POLYGON> polygonList;
			std::vector<OptimizeMesh::O_FACE> faceList;

			unsigned int indexStart;
			unsigned int indexCount;
		};

		//œK : }eA\
		struct O_MATERIAL
		{
			unsigned int index;	//}eÃCfbNX
			std::vector<OptimizeMesh::O_MATERIAL_BLOCK> blockList;
			unsigned int polygonStart;
			unsigned int polygonCount;
		};

		//CfbNX\(œKp)
		struct O_INDEX_INFO
		{
			bool bAssign;
			unsigned int value;

			O_INDEX_INFO( void )
			{
				bAssign = false;
				value = 0;
			}
		};

	private:
		//MESH : }eAwb_\
		struct MESH_MATERIAL_DESC
		{
			unsigned int slotIndex;
			unsigned int opSubsetNum;
			unsigned int tlSubsetNum;
			unsigned int tiSubsetNum;
		};

		//MESH : VvsTuZbg
		struct MESH_SIMPLE_OPACITY_SUBSET
		{
			unsigned int vertexStart;
			unsigned int vertexNum;
			unsigned int indexStart;
			unsigned int indexNum;
		};

		//MESH : uhsTuZbg
		struct MESH_BLEND_OPACITY_SUBSET
		{
			unsigned int boneOffset;
			unsigned int boneNum;
			unsigned int vertexStart;
			unsigned int vertexNum;
			unsigned int indexStart;
			unsigned int indexNum;
		};

		//MESH : VvTuZbg
		struct MESH_SIMPLE_TRANSPARENCY_SUBSET
		{
			unsigned int vertexStart;
			unsigned int vertexNum;
			unsigned int indexStart;
			unsigned int indexNum;
			float sortKey[3];
			unsigned int reserve;
		};

		//MESH : uhTuZbg
		struct MESH_BLEND_TRANSPARENCY_SUBSET
		{
			unsigned int boneOffset;
			unsigned int boneNum;
			unsigned int affectBoneIndex;
			unsigned int vertexStart;
			unsigned int vertexNum;
			unsigned int indexStart;
			unsigned int indexNum;
			float sortKey[3];
		};

	public:
		Mix::Tool::Win32::Graphics::DrawObject* m_pDrawObject;
		Mix::Tool::Win32::Graphics::ObjectModel* m_pObjectModel;

		Mix::Tool::Win32::Graphics::Node* m_pLinkNode;

		std::vector<Mix::Tool::Win32::Graphics::POLYGON> m_PolygonList;

		Mix::Tool::Win32::Graphics::VERTEX_TYPE m_VertexType;
		Mix::Tool::Win32::Graphics::INDEX_TYPE m_IndexType;
		std::vector<OptimizeMesh::VERTEX> m_VertexList;
		std::vector<unsigned int> m_IndexList;
		std::vector<OptimizeMesh::SUBSET> m_SubsetList;

		Mix::Tool::Win32::Graphics::VertexBuffer* m_pVertexBuffer;
		Mix::Tool::Win32::Graphics::IndexBuffer* m_pIndexBuffer;

	private:
		bool Build_Direct( OptimizeMesh::BUILD_CONFIG& cfg );
		bool Build_Optimize( OptimizeMesh::BUILD_CONFIG& cfg );

		bool Build_ProcessBefore( OptimizeMesh::BUILD_CONFIG& cfg, std::vector<OptimizeMesh::O_MATERIAL>& oMaterialList );
		bool Build_ProcessAfter( OptimizeMesh::BUILD_CONFIG& cfg, const std::vector<OptimizeMesh::O_MATERIAL>& oMaterialList );

	public:
		OptimizeMesh( Mix::Tool::Win32::Graphics::DrawObject* pDrawObject, Mix::Tool::Win32::Graphics::Node* pLinkNode );
		virtual ~OptimizeMesh( void );

		//`IuWFNg̎擾
		Mix::Tool::Win32::Graphics::DrawObject* GetDrawObjectPtr( void ) const;

		//Nm[h̎擾
		Mix::Tool::Win32::Graphics::Node* GetLinkNodePtr( void ) const;

		//{[֌W
		virtual bool GetBoneAvaliable( void ) const;
		virtual unsigned int AddBone( const char* pName, const D3DXMATRIX& offsetMat );
		virtual unsigned int AddBone( const wchar_t* pName, const D3DXMATRIX& offsetMat );
		virtual unsigned int GetBoneCount( void ) const;
		virtual const D3DXMATRIX* GetBoneMatList( void ) const;
		virtual const OptimizeMesh::BONE* GetBoneByIndex( unsigned int index ) const;
		virtual const OptimizeMesh::BONE* GetBoneByName( const wchar_t* pName ) const;

		//|S֌W
		void ReservePolygonList( unsigned int count );
		void AddPolygon( const Mix::Tool::Win32::Graphics::POLYGON& polygon );
		bool SetPolygonMaterial( int start, int count, int material );
		void TransformPolygons( const D3DXMATRIX& mat );
		const std::vector<Mix::Tool::Win32::Graphics::POLYGON>& GetPolygonList( void ) const;

		//rh
		bool Build( OptimizeMesh::BUILD_CONFIG& cfg );

		//o[ebNX
		Mix::Tool::Win32::Graphics::VERTEX_TYPE GetVertexType( void ) const;
		const std::vector<OptimizeMesh::VERTEX>& GetVertexList( void ) const;

		//CfbNX
		Mix::Tool::Win32::Graphics::INDEX_TYPE GetIndexType( void ) const;
		const std::vector<unsigned int>& GetIndexList( void ) const;

		//TuZbg
		const std::vector<OptimizeMesh::SUBSET>& GetSubsetList( void ) const;

		// e :
		//   ԃf[^( o[ebNXXgACfbNXXgATuZbgXg )̔j
		//   `惊\[X( o[ebNXobt@ACfbNXobt@AsTuZbgATuZbg )̔j
		//
		// ⑫ :
		//   JgXbhŌĂяoKv
		void Release( void );

		// e :
		//   `obt@̃tbV
		//
		// ⑫ :
		//   uœKvu}eAVF[_[XVvɌĂяoKv( RefreshBuffer RefreshSubset )
		//   JgXbhŌĂяoKv
		bool RefreshBuffer( void );
		bool RefreshBuffer( unsigned int materialSlotIndex );

	protected:
		//rhOCxg
		virtual bool OnBeforeBuild( OptimizeMesh::BUILD_CONFIG& cfg ) { return true; }
		//rhCxg
		virtual bool OnAfterBuild( OptimizeMesh::BUILD_CONFIG& cfg, const std::vector<OptimizeMesh::O_MATERIAL>& oMaterialList ) { return true; }

		//}eȀ
		bool WriteSimpleMaterial( Mix::Tool::Win32::File::OutputStream& output );
		bool WriteBlendMaterial( Mix::Tool::Win32::File::OutputStream& output );

		//obt@̏
		bool WriteVertexBuffer( Mix::Tool::Win32::File::OutputStream& output );
		bool WriteIndexBuffer( Mix::Tool::Win32::File::OutputStream& output );

	private:
		//J[̕`nh
		void OnDrawColor(	const D3DXMATRIX& viewMat,
							const D3DXMATRIX& worldMat,
							std::vector<Mix::Tool::Win32::Graphics::OPACITY_SUBSET>& opacitySubsets,
							std::vector<Mix::Tool::Win32::Graphics::TRANSPARENCY_SUBSET>& transparencySubsets,
							std::vector<Mix::Tool::Win32::Graphics::REFRACT_SUBSET>& refractSubsets );

		//ZNg}bv̕`nh
		void OnDrawSelectMap(	const D3DXMATRIX& viewMat,
								const D3DXMATRIX& worldMat,
								std::vector<Mix::Tool::Win32::Graphics::OPACITY_SUBSET>& subsets );

		//ZNgJ[̃_OCxg
		void OnDrawSelectColor(	const D3DXMATRIX& viewMat,
								const D3DXMATRIX& worldMat,
								std::vector<Mix::Tool::Win32::Graphics::TRANSPARENCY_SUBSET>& subsets );

		//\[g̍쐬
		OptimizeMesh::DRAW_SORT_INFO CreateSortInfo( bool bBoneEnabled, const OptimizeMesh::O_FACE* faceList, unsigned int faceCount );
		OptimizeMesh::DRAW_SORT_INFO CreateSortInfo( unsigned int boneCount, unsigned int vertexStart, unsigned int vertexCount );

		//_
		static bool WriteVertex( const D3DVERTEXELEMENT9* pElements, const OptimizeMesh::VERTEX* pSrc, unsigned char* pDst, unsigned int stride, unsigned int count );

	public:
		virtual unsigned int GetPolygonCount( void ) const;
		virtual unsigned int GetVertexCount( void ) const;
		virtual unsigned int GetIndexCount( void ) const;
		virtual unsigned int GetSubsetCount( void ) const;
		virtual unsigned int GetMaterialSlotIndexBySubsetIndex( unsigned int subsetIndex ) const;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::GRAPHICS__OPTIMIZE_MESH, Mix::Tool::Win32::Graphics::Mesh );

		friend class DrawObject;
		friend class Node;
		friend class ObjectModel;
		friend class OctreeModel;
		friend class MapModel;
	};

}}}}
