#include "Mix/Tool/Win32/Core/Graphics/PixelShader.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

PixelShader* PixelShader::CreateInstance( const void* pBuffer, unsigned int bufferSize )
{
	return new PixelShader( pBuffer, bufferSize );
}

PixelShader::PixelShader( const void* pBuffer, unsigned int bufferSize ) :
m_pD3DPixelShader( NULL )
{
	m_Buffer.resize( bufferSize );
	::CopyMemory( &( m_Buffer[0] ), pBuffer, bufferSize );
}

PixelShader::~PixelShader( void )
{
	MIX_RELEASE( m_pD3DPixelShader );
}

const void* PixelShader::GetBuffer( void ) const
{
	return ( m_Buffer.size() > 0 )? &( m_Buffer[0] ) : NULL;
}

unsigned int PixelShader::GetBufferSize( void ) const
{
	return m_Buffer.size();
}

IDirect3DPixelShader9* PixelShader::GetInterfacePtr( void )
{
	return m_pD3DPixelShader;
}

void PixelShader::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DPixelShader );
}

void PixelShader::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DPixelShader = pManager->D3D_CreatePixelShader( &( m_Buffer[0] ) );
}

Mix::Tool::Win32::Object::TYPE PixelShader::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__PIXEL_SHADER;
}

}}}}
