#pragma once

#include "Mix/Tool/Win32/Core/Object.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class PolygonDivider : public Mix::Tool::Win32::Object
	{
	public:
		static const float DEF_PLANETHICKNESS;

	private:
		enum CPP
		{
			CPP_ON		= 0,
			CPP_FRONT	= 1,
			CPP_BACK	= 2,
		};

	private:
		float m_PlaneThickness;

	private:
		int ClassifyPointToPlane(	const D3DXVECTOR3& p,
									const Mix::Tool::Win32::Graphics::PLANE& plane );

		void IntersectEdgeAgainstPlane( const D3DXVECTOR3& a,
										const D3DXVECTOR3& b,
										const Mix::Tool::Win32::Graphics::PLANE& plane,
										D3DXVECTOR3& cp );

	public:
		PolygonDivider( void );

		//ʂ݂̌̐ݒ܂͎擾
		void SetPlaneThickness( float value );
		float GetPlaneThickness( void ) const;

		//
		void Process(	const Mix::Tool::Win32::Graphics::POLYGON& polygon,
						const Mix::Tool::Win32::Graphics::PLANE& plane,
						Mix::Tool::Win32::Graphics::POLYGON& frontPolygon,
						Mix::Tool::Win32::Graphics::POLYGON& backPolygon );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
	};

}}}}
