#pragma once

#include <vector>
#include <string>

#include "Mix/Tool/Win32/Core/Object.h"
#include "Mix/Tool/Win32/Core/File/InputStream.h"
#include "Mix/Tool/Win32/Core/File/OutputStream.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class ObjectModel;

	class RootMotionCurve : public Mix::Tool::Win32::Object
	{
	private:
		struct MOT_RT_DESC
		{
			unsigned int rotationKeyNum;
			unsigned int translationKeyNum;
		};

		struct MOT_Q_KEY
		{
			float time;
			int reserve;
			float value[4];
		};

		struct MOT_V_KEY
		{
			float time;
			float value[3];
		};

	private:
		Mix::Tool::Win32::Graphics::QuaternionKeyList m_RotationKeyList;
		Mix::Tool::Win32::Graphics::VectorKeyList m_TranslationKeyList;

	private:
//		bool Read( Mix::Tool::Win32::File::InputStream& input, unsigned int rKeyCount, unsigned int tKeyCount );
		bool Write( Mix::Tool::Win32::File::OutputStream& output );

	public:
		RootMotionCurve( void );
		~RootMotionCurve( void );

	public:
		void Initialize( unsigned int rKeyCount, unsigned int tKeyCount );
		void Destroy( void );

		void AddRotationKey( float time, const D3DXQUATERNION& value );
		unsigned int GetRotationKeyCount( void ) const;
		const Mix::Tool::Win32::Graphics::QUATERNION_KEY& GetRotationKey( int index ) const;

		void AddTranslationKey( float time, const D3DXVECTOR3& value );
		unsigned int GetTranslationKeyCount( void ) const;
		const Mix::Tool::Win32::Graphics::VECTOR_KEY& GetTranslationKey( int index ) const;

		float GetLastTime( void );

		bool ExistsKey( void ) const;

		D3DXQUATERNION GetRotation( float time );
		D3DXVECTOR3 GetTranslation( float time );

		D3DXQUATERNION GetRotation( float preTime, float nextTime );
		D3DXVECTOR3 GetTranslation( float preTime, float nextTime );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Motion;
	};

}}}}
