#pragma once

#include "Mix/Tool/Win32/Core/Graphics/DeviceObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class Texture;
	class BackBuffer;

	class SwapChain : public Mix::Tool::Win32::Graphics::DeviceObject
	{
	private:
		D3DPRESENT_PARAMETERS m_D3DPresentParam;
		IDirect3DSwapChain9* m_pD3DSwapChain;
		bool m_bDevice;

		D3DVIEWPORT9 m_D3DViewport;
		RECT m_SrcRect;
		RECT m_DstRect;

		Mix::Tool::Win32::Graphics::BackBuffer* m_pBackBuffer;

	public:
		static SwapChain* CreateInstance( HWND hWnd );

	private:
		SwapChain( HWND hWnd );
		virtual ~SwapChain( void );

		bool IsDevice( void ) const;
		void UpdateParam( void );

	public:
		MIX_REFERENCE_METHOD

		bool IsActive( void ) const;

		bool Begin( void );
		void End( void );
		bool Present( void );

		HWND GetWindowHandle( void ) const;
		const D3DVIEWPORT9& GetViewport( void ) const;
		const RECT& GetBounds( void ) const;
		Mix::Tool::Win32::Graphics::Texture* GetBackBufferPtr( void );

	private:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
