#include "Mix/Tool/Win32/Core/Graphics/TargetTextureD.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

TargetTextureD* TargetTextureD::CreateInstance( D3DFORMAT format )
{
	return new TargetTextureD( format );
}

TargetTextureD::TargetTextureD( D3DFORMAT format ) :
m_pD3DTexture( NULL ),
m_pD3DSurface( NULL )
{
	ZeroMemory( &m_D3DDesc, sizeof( m_D3DDesc ) );

	m_D3DDesc.Format = format;
}

TargetTextureD::~TargetTextureD( void )
{
	MIX_RELEASE( m_pD3DTexture );
	MIX_RELEASE( m_pD3DSurface );
}

bool TargetTextureD::Lock( const RECT& rect, D3DLOCKED_RECT& info )
{
	return false;
}

void TargetTextureD::Unlock( void )
{
}

unsigned int TargetTextureD::GetWidth( void ) const
{
	return m_D3DDesc.Width;
}

unsigned int TargetTextureD::GetHeight( void ) const
{
	return m_D3DDesc.Height;
}

D3DFORMAT TargetTextureD::GetFormat( void ) const
{
	return m_D3DDesc.Format;
}

IDirect3DBaseTexture9* TargetTextureD::GetTexturePtr( void )
{
	return m_pD3DTexture;
}

IDirect3DSurface9* TargetTextureD::GetSurfacePtr( void )
{
	return m_pD3DSurface;
}

void TargetTextureD::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DSurface );
	MIX_RELEASE( m_pD3DTexture );
}

void TargetTextureD::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DTexture = pManager->D3D_CreateTargetTexture( m_D3DDesc );
	if( m_pD3DTexture != NULL )
	{
		m_pD3DTexture->GetSurfaceLevel( 0, &m_pD3DSurface );
	}
}

Mix::Tool::Win32::Object::TYPE TargetTextureD::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__TARGET_TEXTURE_D;
}

}}}}
