#pragma once

#include <string>
#include <vector>

#include "Mix/Tool/Win32/Core/Graphics/TargetTexture.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class TargetTextureD : public Mix::Tool::Win32::Graphics::TargetTexture
	{
	private:
		IDirect3DTexture9* m_pD3DTexture;
		IDirect3DSurface9* m_pD3DSurface;
		D3DSURFACE_DESC m_D3DDesc;

	public:
		static TargetTextureD* CreateInstance( D3DFORMAT format );

	private:
		TargetTextureD( D3DFORMAT format );
		virtual ~TargetTextureD( void );

	public:
		virtual bool Lock( const RECT& rect, D3DLOCKED_RECT& info );
		virtual void Unlock( void );

	public:
		virtual unsigned int GetWidth( void ) const;
		virtual unsigned int GetHeight( void ) const;
		virtual D3DFORMAT GetFormat( void ) const;

		virtual IDirect3DBaseTexture9* GetTexturePtr( void );
		virtual IDirect3DSurface9* GetSurfacePtr( void );

	public:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
